/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class UnicastTest
extends ReceiverAdapter {
    private JChannel channel;
    private final MyReceiver receiver = new MyReceiver();
    static final String groupname = "UnicastTest-Group";
    private long sleep_time = 0L;
    private boolean exit_on_end = false;
    private boolean busy_sleep = false;
    private boolean oob = false;
    private int num_threads = 1;
    private int num_msgs = 100000;
    private int msg_size = 1000;

    public void init(String props, long sleep_time, boolean exit_on_end, boolean busy_sleep, String name) throws Exception {
        this.sleep_time = sleep_time;
        this.exit_on_end = exit_on_end;
        this.busy_sleep = busy_sleep;
        this.channel = new JChannel(props);
        if (name != null) {
            this.channel.setName(name);
        }
        this.channel.connect(groupname);
        this.channel.setReceiver(this.receiver);
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel in JMX failed: " + ex);
        }
    }

    public void eventLoop() throws Exception {
        block13: while (true) {
            System.out.print("[1] Send msgs [2] Print view [3] Print conns [4] Trash conn [5] Trash all conns\n[6] Set sender threads (" + this.num_threads + ") [7] Set num msgs (" + this.num_msgs + ") " + "[8] Set msg size (" + Util.printBytes(this.msg_size) + ")" + "\n[o] Toggle OOB (" + this.oob + ")\n[q] Quit\n");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block13;
                }
                case 49: {
                    this.sendMessages();
                    continue block13;
                }
                case 50: {
                    this.printView();
                    continue block13;
                }
                case 51: {
                    this.printConnections();
                    continue block13;
                }
                case 52: {
                    this.removeConnection();
                    continue block13;
                }
                case 53: {
                    this.removeAllConnections();
                    continue block13;
                }
                case 54: {
                    this.setSenderThreads();
                    continue block13;
                }
                case 55: {
                    this.setNumMessages();
                    continue block13;
                }
                case 56: {
                    this.setMessageSize();
                    continue block13;
                }
                case 111: {
                    this.oob = !this.oob;
                    System.out.println("oob=" + this.oob);
                    continue block13;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    private void printConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(UNICAST.class, UNICAST2.class);
        if (prot instanceof UNICAST) {
            System.out.println(((UNICAST)prot).printConnections());
        } else if (prot instanceof UNICAST2) {
            System.out.println(((UNICAST2)prot).printConnections());
        }
    }

    private void removeConnection() {
        Address member = this.getReceiver();
        if (member != null) {
            Protocol prot = this.channel.getProtocolStack().findProtocol(UNICAST.class, UNICAST2.class);
            if (prot instanceof UNICAST) {
                ((UNICAST)prot).removeConnection(member);
            } else if (prot instanceof UNICAST2) {
                ((UNICAST2)prot).removeConnection(member);
            }
        }
    }

    private void removeAllConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(UNICAST.class, UNICAST2.class);
        if (prot instanceof UNICAST) {
            ((UNICAST)prot).removeAllConnections();
        } else if (prot instanceof UNICAST2) {
            ((UNICAST2)prot).removeAllConnections();
        }
    }

    void sendMessages() throws Exception {
        Address destination = this.getReceiver();
        if (destination == null) {
            System.err.println("UnicastTest.sendMessages(): receiver is null, cannot send messages");
            return;
        }
        if (this.num_threads > 1 && this.num_msgs % this.num_threads != 0) {
            System.err.println("num_msgs (" + this.num_msgs + " ) has to be divisible by num_threads (" + this.num_threads + ")");
            return;
        }
        System.out.println("sending " + this.num_msgs + " messages (" + Util.printBytes(this.msg_size) + ") to " + destination + ": oob=" + this.oob + ", " + this.num_threads + " sender thread(s)");
        byte[] buf = Util.objectToByteBuffer(new StartData(this.num_msgs));
        Message msg = new Message(destination, null, buf);
        this.channel.send(msg);
        long print = this.num_msgs / 10;
        int msgs_per_sender = this.num_msgs / this.num_threads;
        Sender[] senders = new Sender[this.num_threads];
        for (int i = 0; i < senders.length; ++i) {
            senders[i] = new Sender(msgs_per_sender, this.msg_size, destination, (int)print);
        }
        for (Sender sender : senders) {
            sender.start();
        }
        for (Sender sender : senders) {
            sender.join();
        }
        System.out.println("done sending " + this.num_msgs + " to " + destination);
    }

    void setSenderThreads() throws Exception {
        int threads = Util.readIntFromStdin("Number of sender threads: ");
        int old = this.num_threads;
        this.num_threads = threads;
        System.out.println("sender threads set to " + this.num_threads + " (from " + old + ")");
    }

    void setNumMessages() throws Exception {
        this.num_msgs = Util.readIntFromStdin("Number of messages: ");
        System.out.println("Set num_msgs=" + this.num_msgs);
    }

    void setMessageSize() throws Exception {
        this.msg_size = Util.readIntFromStdin("Message size: ");
        System.out.println("set msg_size=" + this.msg_size);
    }

    void printView() {
        System.out.println("\n-- view: " + this.channel.getView() + '\n');
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Address getReceiver() {
        List<Address> mbrs = null;
        try {
            mbrs = this.channel.getView().getMembers();
            System.out.println("pick receiver from the following members:");
            int i = 0;
            for (Address mbr : mbrs) {
                if (mbr.equals(this.channel.getAddress())) {
                    System.out.println("[" + i + "]: " + mbr + " (self)");
                } else {
                    System.out.println("[" + i + "]: " + mbr);
                }
                ++i;
            }
            System.out.flush();
            System.in.skip(System.in.available());
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String tmp = reader.readLine().trim();
            int index = Integer.parseInt(tmp);
            return mbrs.get(index);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        long sleep_time = 0L;
        boolean exit_on_end = false;
        boolean busy_sleep = false;
        String props = null;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-sleep".equals(args[i])) {
                sleep_time = Long.parseLong(args[++i]);
                continue;
            }
            if ("-exit_on_end".equals(args[i])) {
                exit_on_end = true;
                continue;
            }
            if ("-busy_sleep".equals(args[i])) {
                busy_sleep = true;
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            UnicastTest.help();
            return;
        }
        try {
            UnicastTest test = new UnicastTest();
            test.init(props, sleep_time, exit_on_end, busy_sleep, name);
            test.eventLoop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("UnicastTest [-help] [-props <props>] [-sleep <time in ms between msg sends] [-exit_on_end] [-busy-sleep] [-name name]");
    }

    private class MyReceiver
    extends ReceiverAdapter {
        private boolean started = false;
        private long start = 0L;
        private long stop = 0L;
        private long tmp = 0L;
        private long num_values = 0L;
        private long total_time = 0L;
        private long msgs_per_sec;
        private long print;
        private AtomicLong current_value = new AtomicLong(0L);
        private AtomicLong total_bytes = new AtomicLong(0L);

        private MyReceiver() {
        }

        @Override
        public void receive(Message msg) {
            Data data;
            try {
                data = (Data)Util.objectFromByteBuffer(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (data instanceof StartData) {
                if (this.started) {
                    System.err.println("UnicastTest.run(): received START data, but am already processing data");
                } else {
                    this.started = true;
                    this.current_value.set(0L);
                    this.tmp = 0L;
                    this.num_values = ((StartData)data).num_values;
                    this.print = this.num_values / 10L;
                    this.total_bytes.set(0L);
                    this.start = System.currentTimeMillis();
                }
            } else if (data instanceof Value) {
                this.tmp = ((Value)data).value;
                long new_val = this.current_value.incrementAndGet();
                if (((Value)data).buf != null) {
                    this.total_bytes.addAndGet(((Value)data).buf.length);
                }
                if (new_val % this.print == 0L) {
                    System.out.println("received " + this.current_value);
                }
                if (new_val >= this.num_values) {
                    this.stop = System.currentTimeMillis();
                    this.total_time = this.stop - this.start;
                    this.msgs_per_sec = (long)((double)this.num_values / ((double)this.total_time / 1000.0));
                    double throughput = (double)this.total_bytes.get() / ((double)this.total_time / 1000.0);
                    System.out.println("-- received " + this.num_values + " messages (" + Util.printBytes(this.total_bytes.get()) + ") in " + this.total_time + " ms (" + this.msgs_per_sec + " messages/sec, " + Util.printBytes(throughput) + " / sec)");
                    this.started = false;
                    if (UnicastTest.this.exit_on_end) {
                        System.exit(0);
                    }
                }
            }
        }

        @Override
        public void viewAccepted(View new_view) {
            System.out.println("** view: " + new_view);
        }
    }

    private class Sender
    extends Thread {
        private final int number_of_msgs;
        private final int message_size;
        private final Address destination;
        private final int print;

        public Sender(int num_msgs, int msg_size, Address destination, int print) {
            this.number_of_msgs = num_msgs;
            this.message_size = msg_size;
            this.destination = destination;
            this.print = print;
        }

        @Override
        public void run() {
            for (int i = 1; i <= this.number_of_msgs; ++i) {
                Value val = new Value(i, this.message_size);
                byte[] buf = new byte[]{};
                try {
                    buf = Util.objectToByteBuffer(val);
                    Message msg = new Message(this.destination, null, buf);
                    if (UnicastTest.this.oob) {
                        msg.setFlag(Message.OOB);
                    }
                    if (i > 0 && this.print > 0 && i % this.print == 0) {
                        System.out.println("-- sent " + i);
                    }
                    UnicastTest.this.channel.send(msg);
                    if (UnicastTest.this.sleep_time <= 0L) continue;
                    Util.sleep(UnicastTest.this.sleep_time, UnicastTest.this.busy_sleep);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Value
    extends Data {
        long value = 0L;
        byte[] buf = null;

        public Value() {
        }

        Value(long value, int len) {
            this.value = value;
            if (len > 0) {
                this.buf = new byte[len];
            }
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeLong(this.value);
            if (this.buf != null) {
                out.writeInt(this.buf.length);
                out.write(this.buf, 0, this.buf.length);
            } else {
                out.writeInt(0);
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.value = in.readLong();
            int len = in.readInt();
            if (len > 0) {
                this.buf = new byte[len];
                in.readFully(this.buf, 0, len);
            }
        }
    }

    public static class StartData
    extends Data {
        long num_values = 0L;

        public StartData() {
        }

        StartData(long num_values) {
            this.num_values = num_values;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeLong(this.num_values);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.num_values = in.readLong();
        }
    }

    public static abstract class Data
    implements Streamable {
    }
}

