/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.metadata.VersionRange;
import org.jboss.osgi.resolver.v2.XHostRequirement;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractRequirement;
import org.osgi.framework.Version;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Resource;

public class AbstractHostRequirement
extends AbstractRequirement
implements XHostRequirement {
    private final String symbolicName = (String)this.getAttribute("osgi.wiring.host");
    private final VersionRange versionrange;

    protected AbstractHostRequirement(Resource res, Map<String, Object> atts, Map<String, String> dirs) {
        super(res, "osgi.wiring.host", atts, dirs);
        Object versionatt = atts.get("bundle-version");
        if (versionatt instanceof String) {
            versionatt = VersionRange.parse((String)((String)versionatt));
        }
        this.versionrange = (VersionRange)versionatt;
    }

    @Override
    protected Set<String> getMandatoryAttributes() {
        return Collections.singleton("osgi.wiring.host");
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionrange;
    }

    @Override
    public boolean matches(Capability cap) {
        Version version;
        if (!super.matches(cap)) {
            return false;
        }
        return this.versionrange == null || this.versionrange.isInRange(version = ((XIdentityCapability)cap).getVersion());
    }
}

