/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.loggers.LoggerAssignHandler;
import org.jboss.as.logging.loggers.LoggerService;
import org.jboss.as.logging.util.LogServices;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class LoggerAdd
extends AbstractAddStepHandler {
    public static final LoggerAdd INSTANCE = new LoggerAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.LEVEL.validateAndSet(operation, model);
        CommonAttributes.HANDLERS.validateAndSet(operation, model);
        CommonAttributes.USE_PARENT_HANDLERS.validateAndSet(operation, model);
        CommonAttributes.FILTER.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ModelNode level = CommonAttributes.LEVEL.resolveModelAttribute(context, model);
        ModelNode useParentHandlers = CommonAttributes.USE_PARENT_HANDLERS.resolveModelAttribute(context, model);
        ModelNode filter = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        ServiceTarget target = context.getServiceTarget();
        try {
            LoggerService service = new LoggerService(name);
            if (level.isDefined()) {
                service.setLevel(ModelParser.parseLevel(level));
            }
            if (useParentHandlers.isDefined()) {
                service.setUseParentHandlers(useParentHandlers.asBoolean());
            }
            if (filter.isDefined()) {
                service.setFilter(ModelParser.parseFilter(context, filter));
            }
            newControllers.add(target.addService(LogServices.loggerName(name), (Service)service).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
        try {
            ModelNode handlers = CommonAttributes.HANDLERS.resolveModelAttribute(context, model);
            if (handlers.isDefined()) {
                newControllers.addAll(LoggerAssignHandler.installHandlers(target, name, handlers, verificationHandler));
            }
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
    }
}

