/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.io.WriteOnCloseOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingConstants;
import org.apache.cxf.ws.addressing.AddressingConstantsImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.addressing.v200408.AttributedURI;
import org.apache.cxf.ws.rm.ObjectFactory;

public final class RMUtils {
    private static final org.apache.cxf.ws.addressing.v200408.ObjectFactory WSA_FACTORY = new org.apache.cxf.ws.addressing.v200408.ObjectFactory();
    private static final ObjectFactory WSRM_FACTORY = new ObjectFactory();
    private static final AddressingConstants WSA_CONSTANTS = new AddressingConstantsImpl();

    protected RMUtils() {
    }

    public static org.apache.cxf.ws.addressing.v200408.ObjectFactory getWSAFactory() {
        return WSA_FACTORY;
    }

    public static ObjectFactory getWSRMFactory() {
        return WSRM_FACTORY;
    }

    public static AddressingConstants getAddressingConstants() {
        return WSA_CONSTANTS;
    }

    public static EndpointReferenceType createAnonymousReference() {
        return RMUtils.createReference("http://www.w3.org/2005/08/addressing/anonymous");
    }

    public static org.apache.cxf.ws.addressing.v200408.EndpointReferenceType createAnonymousReference2004() {
        return VersionTransformer.convert((EndpointReferenceType)RMUtils.createAnonymousReference());
    }

    public static EndpointReferenceType createNoneReference() {
        return RMUtils.createReference("http://www.w3.org/2005/08/addressing/none");
    }

    public static org.apache.cxf.ws.addressing.v200408.EndpointReferenceType createNoneReference2004() {
        return VersionTransformer.convert((EndpointReferenceType)RMUtils.createNoneReference());
    }

    public static EndpointReferenceType createReference(String address) {
        org.apache.cxf.ws.addressing.ObjectFactory factory = new org.apache.cxf.ws.addressing.ObjectFactory();
        EndpointReferenceType epr = factory.createEndpointReferenceType();
        AttributedURIType uri = factory.createAttributedURIType();
        uri.setValue(address);
        epr.setAddress(uri);
        return epr;
    }

    public static org.apache.cxf.ws.addressing.v200408.EndpointReferenceType createReference2004(String address) {
        org.apache.cxf.ws.addressing.v200408.ObjectFactory factory = new org.apache.cxf.ws.addressing.v200408.ObjectFactory();
        org.apache.cxf.ws.addressing.v200408.EndpointReferenceType epr = factory.createEndpointReferenceType();
        AttributedURI uri = factory.createAttributedURI();
        uri.setValue(address);
        epr.setAddress(uri);
        return epr;
    }

    public static String getEndpointIdentifier(Endpoint endpoint) {
        return MessageFormat.format("{0}.{1}", endpoint.getEndpointInfo().getService().getName(), endpoint.getEndpointInfo().getName());
    }

    public static WriteOnCloseOutputStream createCachedStream(Message message, OutputStream os) {
        if (!(os instanceof WriteOnCloseOutputStream)) {
            WriteOnCloseOutputStream cached = new WriteOnCloseOutputStream(os);
            message.setContent(OutputStream.class, (Object)cached);
            os = cached;
        }
        return (WriteOnCloseOutputStream)os;
    }
}

