/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.JDBCParameterSetter;
import org.jboss.as.cmp.jdbc.JDBCResultSetReader;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.Mapper;

public final class JDBCTypeSimple
implements JDBCType {
    private final String[] columnNames;
    private final Class[] javaTypes;
    private final int[] jdbcTypes;
    private final String[] sqlTypes;
    private final boolean[] notNull;
    private final boolean[] autoIncrement;
    private final JDBCResultSetReader[] resultSetReader;
    private final JDBCParameterSetter[] paramSetter;
    private final Mapper mapper;

    public JDBCTypeSimple(String columnName, Class javaType, int jdbcType, String sqlType, boolean notNull, boolean autoIncrement, Mapper mapper, JDBCParameterSetter paramSetter, JDBCResultSetReader resultReader) {
        this.columnNames = new String[]{columnName};
        this.javaTypes = new Class[]{javaType};
        this.jdbcTypes = new int[]{jdbcType};
        this.sqlTypes = new String[]{sqlType};
        this.notNull = new boolean[]{notNull};
        this.autoIncrement = new boolean[]{autoIncrement};
        this.mapper = mapper;
        this.resultSetReader = new JDBCResultSetReader[]{resultReader};
        this.paramSetter = new JDBCParameterSetter[]{paramSetter};
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Class[] getJavaTypes() {
        return this.javaTypes;
    }

    @Override
    public int[] getJDBCTypes() {
        return this.jdbcTypes;
    }

    @Override
    public String[] getSQLTypes() {
        return this.sqlTypes;
    }

    @Override
    public boolean[] getNotNull() {
        return this.notNull;
    }

    @Override
    public boolean[] getAutoIncrement() {
        return this.autoIncrement;
    }

    @Override
    public Object getColumnValue(int index, Object value) {
        if (index != 0) {
            throw CmpMessages.MESSAGES.simpleTypeRequiresOneIndex();
        }
        return this.mapper == null ? value : this.mapper.toColumnValue(value);
    }

    @Override
    public Object setColumnValue(int index, Object value, Object columnValue) {
        if (index != 0) {
            throw CmpMessages.MESSAGES.simpleTypeRequiresOneIndex();
        }
        return this.mapper == null ? columnValue : this.mapper.toFieldValue(columnValue);
    }

    @Override
    public boolean hasMapper() {
        return this.mapper != null;
    }

    @Override
    public boolean isSearchable() {
        int jdbcType = this.jdbcTypes[0];
        return jdbcType != -2 && jdbcType != 2004 && jdbcType != 2005 && jdbcType != -4 && jdbcType != -1 && jdbcType != -3;
    }

    @Override
    public JDBCResultSetReader[] getResultSetReaders() {
        return this.resultSetReader;
    }

    @Override
    public JDBCParameterSetter[] getParameterSetter() {
        return this.paramSetter;
    }
}

