/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bucket;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public final class Bucket {
    final Map<Object, InternalCacheEntry> entries = new HashMap<Object, InternalCacheEntry>(32);
    private transient Integer bucketId;
    private transient String bucketIdStr;

    public final void addEntry(InternalCacheEntry se) {
        this.entries.put(se.getKey(), se);
    }

    public final boolean removeEntry(Object key) {
        return this.entries.remove(key) != null;
    }

    public final InternalCacheEntry getEntry(Object key) {
        return this.entries.get(key);
    }

    public Map<Object, InternalCacheEntry> getEntries() {
        return this.entries;
    }

    public Integer getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(Integer bucketId) {
        this.bucketId = bucketId;
        this.bucketIdStr = bucketId.toString();
    }

    public void setBucketId(String bucketId) {
        try {
            this.setBucketId(Integer.parseInt(bucketId));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bucketId: " + bucketId + " (expected: integer)");
        }
    }

    public String getBucketIdAsString() {
        return this.bucketIdStr;
    }

    public boolean removeExpiredEntries() {
        boolean result = false;
        long currentTimeMillis = 0L;
        Iterator<Map.Entry<Object, InternalCacheEntry>> entryIterator = this.entries.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Object, InternalCacheEntry> entry = entryIterator.next();
            InternalCacheEntry value = entry.getValue();
            if (!value.canExpire()) continue;
            if (currentTimeMillis == 0L) {
                currentTimeMillis = System.currentTimeMillis();
            }
            if (!entry.getValue().isExpired(currentTimeMillis)) continue;
            entryIterator.remove();
            result = true;
        }
        return result;
    }

    public Collection<? extends InternalCacheEntry> getStoredEntries() {
        return this.entries.values();
    }

    public long timestampOfFirstEntryToExpire() {
        long result = Long.MAX_VALUE;
        for (InternalCacheEntry se : this.entries.values()) {
            if (se.getExpiryTime() >= result) continue;
            result = se.getExpiryTime();
        }
        return result;
    }

    public String toString() {
        return "Bucket{entries=" + this.entries + ", bucketId='" + this.bucketId + '\'' + '}';
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public void clearEntries() {
        this.entries.clear();
    }

    public static class Externalizer
    extends AbstractExternalizer<Bucket> {
        private static final long serialVersionUID = -5291318076267612501L;

        @Override
        public void writeObject(ObjectOutput output, Bucket b) throws IOException {
            Map<Object, InternalCacheEntry> entries = b.entries;
            UnsignedNumeric.writeUnsignedInt(output, entries.size());
            for (InternalCacheEntry se : entries.values()) {
                output.writeObject(se);
            }
        }

        @Override
        public Bucket readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Bucket b = new Bucket();
            int numEntries = UnsignedNumeric.readUnsignedInt(input);
            for (int i = 0; i < numEntries; ++i) {
                b.addEntry((InternalCacheEntry)input.readObject());
            }
            return b;
        }

        @Override
        public Integer getId() {
            return 42;
        }

        @Override
        public Set<Class<? extends Bucket>> getTypeClasses() {
            return Util.asSet(Bucket.class);
        }
    }
}

