/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.weld.injection.ParameterInjectionPoint;
import org.jboss.as.weld.injection.SecurityActions;
import org.jboss.weld.manager.BeanManagerImpl;

public class InjectableConstructor {
    private final Constructor constructor;
    private final ParameterInjectionPoint[] parameterInjectionPoints;
    private final Bean[] beans;
    private final BeanManagerImpl beanManager;

    public InjectableConstructor(AnnotatedConstructor<?> constructor, BeanManagerImpl beanManager, Bean bean) {
        this.constructor = constructor.getJavaMember();
        SecurityActions.setAccessible(this.constructor);
        this.parameterInjectionPoints = new ParameterInjectionPoint[constructor.getParameters().size()];
        this.beans = new Bean[this.parameterInjectionPoints.length];
        this.beanManager = beanManager;
        for (AnnotatedParameter parameter : constructor.getParameters()) {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            for (Annotation annotation : parameter.getAnnotations()) {
                if (!beanManager.isQualifier(annotation.annotationType())) continue;
                qualifiers.add(annotation);
            }
            ParameterInjectionPoint injectionPoint = new ParameterInjectionPoint(parameter, qualifiers, bean);
            Set ipBeans = beanManager.getBeans((InjectionPoint)injectionPoint);
            Bean ipBean = beanManager.resolve(ipBeans);
            this.parameterInjectionPoints[parameter.getPosition()] = injectionPoint;
            this.beans[parameter.getPosition()] = ipBean;
        }
    }

    public Object createInstance(CreationalContext<?> ctx) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object[] params = new Object[this.beans.length];
        for (int i = 0; i < this.beans.length; ++i) {
            params[i] = this.beanManager.getReference((InjectionPoint)this.parameterInjectionPoints[i], this.beans[i], ctx);
        }
        return this.constructor.newInstance(params);
    }
}

