/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class WrappedInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WrappedInInterceptor.class);

    public WrappedInInterceptor() {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        if (this.isGET(message) && message.getContent(List.class) != null) {
            LOG.fine("WrappedInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            return;
        }
        BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        boolean requestor = this.isRequestor(message);
        if (operation == null) {
            String local = xmlReader.getLocalName();
            if (requestor && local.endsWith("Response")) {
                local = local.substring(0, local.length() - 8);
            }
            if ((operation = ServiceModelUtil.getOperation((Exchange)message.getExchange(), (String)local)) == null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, new Object[]{local}), Fault.FAULT_CODE_CLIENT);
            }
        }
        ServiceInfo si = operation.getBinding().getService();
        DataReader<XMLStreamReader> dr = this.getDataReader(message);
        MessageContentsList objects = new MessageContentsList();
        MessageInfo msgInfo = this.setMessage(message, operation, requestor, si);
        if (operation.isUnwrappedCapable() && ((MessagePartInfo)msgInfo.getMessageParts().get(0)).getTypeClass() != null) {
            Object wrappedObject = dr.read((MessagePartInfo)msgInfo.getMessageParts().get(0), (Object)xmlReader);
            objects.put((MessagePartInfo)msgInfo.getMessageParts().get(0), wrappedObject);
        } else {
            if (operation.isUnwrappedCapable()) {
                operation = operation.getUnwrappedOperation();
            }
            msgInfo = this.setMessage(message, operation, requestor, si);
            List messageParts = msgInfo.getMessageParts();
            Iterator itr = messageParts.iterator();
            if (xmlReader.getEventType() == 1) {
                StaxUtils.nextEvent((XMLStreamReader)xmlReader);
            }
            while (StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
                MessagePartInfo part = (MessagePartInfo)itr.next();
                objects.put(part, dr.read(part, (Object)xmlReader));
            }
        }
        message.setContent(List.class, (Object)objects);
    }

    private MessageInfo setMessage(Message message, BindingOperationInfo operation, boolean requestor, ServiceInfo si) {
        MessageInfo msgInfo = this.getMessageInfo(message, operation, requestor);
        message.put(MessageInfo.class, (Object)msgInfo);
        message.getExchange().put(BindingOperationInfo.class, (Object)operation);
        message.getExchange().put(OperationInfo.class, (Object)operation.getOperationInfo());
        message.getExchange().setOneWay(operation.getOperationInfo().isOneWay());
        message.put((Object)"javax.xml.ws.wsdl.operation", (Object)operation.getName());
        QName serviceQName = si.getName();
        message.put((Object)"javax.xml.ws.wsdl.service", (Object)serviceQName);
        QName interfaceQName = si.getInterface().getName();
        message.put((Object)"javax.xml.ws.wsdl.interface", (Object)interfaceQName);
        EndpointInfo endpointInfo = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
        QName portQName = endpointInfo.getName();
        message.put((Object)"javax.xml.ws.wsdl.port", (Object)portQName);
        String address = endpointInfo.getAddress();
        URI wsdlDescription = null;
        try {
            wsdlDescription = new URI(address + "?wsdl");
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        message.put((Object)"javax.xml.ws.wsdl.description", wsdlDescription);
        return msgInfo;
    }
}

