/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security.jaspi.modules;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.Base64;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.jboss.as.web.security.jaspi.modules.WebServerAuthModule;
import org.jboss.logging.Logger;

public class HTTPBasicServerAuthModule
extends WebServerAuthModule {
    private static Logger log = Logger.getLogger((String)"org.jboss.as.web.security");
    protected Context context;
    protected boolean cache = false;
    public static final byte[] AUTHENTICATE_BYTES = new byte[]{87, 87, 87, 45, 65, 117, 116, 104, 101, 110, 116, 105, 99, 97, 116, 101};
    protected String delegatingLoginContextName = null;

    public HTTPBasicServerAuthModule() {
    }

    public HTTPBasicServerAuthModule(String delegatingLoginContextName) {
        this.delegatingLoginContextName = delegatingLoginContextName;
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SUCCESS;
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Request request = (Request)messageInfo.getRequestMessage();
        Response response = (Response)messageInfo.getResponseMessage();
        this.context = request.getContext();
        LoginConfig config = this.context.getLoginConfig();
        String username = null;
        String password = null;
        MessageBytes authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        if (authorization != null) {
            Principal principal;
            authorization.toBytes();
            ByteChunk authorizationBC = authorization.getByteChunk();
            if (authorizationBC.startsWithIgnoreCase("basic ", 0)) {
                authorizationBC.setOffset(authorizationBC.getOffset() + 6);
                CharChunk authorizationCC = authorization.getCharChunk();
                Base64.decode((ByteChunk)authorizationBC, (CharChunk)authorizationCC);
                int colon = authorizationCC.indexOf(':');
                if (colon < 0) {
                    username = authorizationCC.toString();
                } else {
                    char[] buf = authorizationCC.getBuffer();
                    username = new String(buf, 0, colon);
                    password = new String(buf, colon + 1, authorizationCC.getEnd() - colon - 1);
                }
                authorizationBC.setOffset(authorizationBC.getOffset() - 6);
            }
            if ((principal = this.context.getRealm().authenticate(username, password)) != null) {
                this.registerWithCallbackHandler(principal, username, password);
                return AuthStatus.SUCCESS;
            }
        }
        MessageBytes authenticate = response.getCoyoteResponse().getMimeHeaders().addValue(AUTHENTICATE_BYTES, 0, AUTHENTICATE_BYTES.length);
        CharChunk authenticateCC = authenticate.getCharChunk();
        try {
            authenticateCC.append("Basic realm=\"");
            if (config.getRealmName() == null) {
                authenticateCC.append(request.getServerName());
                authenticateCC.append(':');
                authenticateCC.append(Integer.toString(request.getServerPort()));
            } else {
                authenticateCC.append(config.getRealmName());
            }
            authenticateCC.append('\"');
            authenticate.toChars();
            response.sendError(401);
        }
        catch (IOException e) {
            // empty catch block
        }
        return AuthStatus.FAILURE;
    }
}

