/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.annotation.javaee.DisplayNames;
import org.jboss.annotation.javaee.Icons;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.DisplayNameImpl;
import org.jboss.metadata.javaee.spec.DisplayNamesImpl;
import org.jboss.metadata.javaee.spec.IconImpl;
import org.jboss.metadata.javaee.spec.IconsImpl;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.RunAsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.AnnotationMetaData;
import org.jboss.metadata.web.spec.AnnotationsMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletSecurityMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class WarAnnotationDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final DotName webFilter = DotName.createSimple((String)WebFilter.class.getName());
    private static final DotName webListener = DotName.createSimple((String)WebListener.class.getName());
    private static final DotName webServlet = DotName.createSimple((String)WebServlet.class.getName());
    private static final DotName runAs = DotName.createSimple((String)RunAs.class.getName());
    private static final DotName declareRoles = DotName.createSimple((String)DeclareRoles.class.getName());
    private static final DotName multipartConfig = DotName.createSimple((String)MultipartConfig.class.getName());
    private static final DotName servletSecurity = DotName.createSimple((String)ServletSecurity.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        Map<String, WebMetaData> annotationsMetaData = warMetaData.getAnnotationsMetaData();
        if (annotationsMetaData == null) {
            annotationsMetaData = new HashMap<String, WebMetaData>();
            warMetaData.setAnnotationsMetaData(annotationsMetaData);
        }
        Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
        for (Map.Entry entry : indexes.entrySet()) {
            Index jarIndex = (Index)entry.getValue();
            annotationsMetaData.put(((ResourceRoot)entry.getKey()).getRootName(), this.processAnnotations(jarIndex));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected WebMetaData processAnnotations(Index index) throws DeploymentUnitProcessingException {
        List servletSecurityAnnotations;
        List multipartConfigAnnotations;
        List declareRolesAnnotations;
        List runAsAnnotations;
        List webListenerAnnotations;
        ClassInfo classInfo;
        AnnotationTarget target;
        List webFilterAnnotations;
        ArrayList<String> urlPatterns;
        AnnotationValue largeIconValue;
        AnnotationValue smallIconValue;
        AnnotationValue displayNameValue;
        AnnotationValue descriptionValue;
        DescriptionGroupMetaData descriptionGroup;
        AnnotationValue initParamValue;
        AnnotationValue initParamName;
        ParamValueMetaData initParam;
        ArrayList<ParamValueMetaData> initParams;
        AnnotationInstance[] initParamsAnnotations;
        AnnotationValue initParamsValue;
        AnnotationValue asyncSupported;
        Web30MetaData metaData = new Web30MetaData();
        List webServletAnnotations = index.getAnnotations(webServlet);
        if (webServletAnnotations != null && webServletAnnotations.size() > 0) {
            ServletsMetaData servlets = new ServletsMetaData();
            ArrayList<ServletMappingMetaData> servletMappings = new ArrayList<ServletMappingMetaData>();
            for (AnnotationInstance annotation : webServletAnnotations) {
                ServletMetaData servlet = new ServletMetaData();
                AnnotationTarget target2 = annotation.target();
                if (!(target2 instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidWebServletAnnotation(target2));
                }
                ClassInfo classInfo2 = (ClassInfo)ClassInfo.class.cast(target2);
                servlet.setServletClass(classInfo2.toString());
                AnnotationValue nameValue = annotation.value("name");
                if (nameValue == null || nameValue.asString().isEmpty()) {
                    servlet.setName(classInfo2.toString());
                } else {
                    servlet.setName(nameValue.asString());
                }
                AnnotationValue loadOnStartup = annotation.value("loadOnStartup");
                if (loadOnStartup != null && loadOnStartup.asInt() > 0) {
                    servlet.setLoadOnStartupInt(loadOnStartup.asInt());
                }
                if ((asyncSupported = annotation.value("asyncSupported")) != null) {
                    servlet.setAsyncSupported(asyncSupported.asBoolean());
                }
                if ((initParamsValue = annotation.value("initParams")) != null && (initParamsAnnotations = initParamsValue.asNestedArray()) != null && initParamsAnnotations.length > 0) {
                    initParams = new ArrayList<ParamValueMetaData>();
                    for (AnnotationInstance initParamsAnnotation : initParamsAnnotations) {
                        Descriptions descriptions;
                        initParam = new ParamValueMetaData();
                        initParamName = initParamsAnnotation.value("name");
                        initParamValue = initParamsAnnotation.value();
                        if (initParamName == null || initParamValue == null) {
                            throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidWebInitParamAnnotation(target2));
                        }
                        AnnotationValue initParamDescription = initParamsAnnotation.value("description");
                        initParam.setParamName(initParamName.asString());
                        initParam.setParamValue(initParamValue.asString());
                        if (initParamDescription != null && (descriptions = this.getDescription(initParamDescription.asString())) != null) {
                            initParam.setDescriptions(descriptions);
                        }
                        initParams.add(initParam);
                    }
                    servlet.setInitParam(initParams);
                }
                if ((descriptionGroup = this.getDescriptionGroup((descriptionValue = annotation.value("description")) == null ? "" : descriptionValue.asString(), (displayNameValue = annotation.value("displayName")) == null ? "" : displayNameValue.asString(), (smallIconValue = annotation.value("smallIcon")) == null ? "" : smallIconValue.asString(), (largeIconValue = annotation.value("largeIcon")) == null ? "" : largeIconValue.asString())) != null) {
                    servlet.setDescriptionGroup(descriptionGroup);
                }
                ServletMappingMetaData servletMapping = new ServletMappingMetaData();
                servletMapping.setServletName(servlet.getName());
                urlPatterns = new ArrayList<String>();
                AnnotationValue urlPatternsValue = annotation.value("urlPatterns");
                if (urlPatternsValue != null) {
                    for (String urlPattern : urlPatternsValue.asStringArray()) {
                        urlPatterns.add(urlPattern);
                    }
                }
                if ((urlPatternsValue = annotation.value()) != null) {
                    for (String urlPattern : urlPatternsValue.asStringArray()) {
                        urlPatterns.add(urlPattern);
                    }
                }
                if (urlPatterns.size() > 0) {
                    servletMapping.setUrlPatterns(urlPatterns);
                    servletMappings.add(servletMapping);
                }
                servlets.add((MappableMetaData)servlet);
            }
            metaData.setServlets(servlets);
            metaData.setServletMappings(servletMappings);
        }
        if ((webFilterAnnotations = index.getAnnotations(webFilter)) != null && webFilterAnnotations.size() > 0) {
            FiltersMetaData filters = new FiltersMetaData();
            ArrayList<FilterMappingMetaData> filterMappings = new ArrayList<FilterMappingMetaData>();
            for (AnnotationInstance annotation : webFilterAnnotations) {
                AnnotationValue dispatcherTypesValue;
                AnnotationValue servletNamesValue;
                FilterMetaData filter = new FilterMetaData();
                target = annotation.target();
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidWebFilterAnnotation(target));
                }
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                filter.setFilterClass(classInfo.toString());
                AnnotationValue nameValue = annotation.value("filterName");
                if (nameValue == null || nameValue.asString().isEmpty()) {
                    filter.setName(classInfo.toString());
                } else {
                    filter.setName(nameValue.asString());
                }
                asyncSupported = annotation.value("asyncSupported");
                if (asyncSupported != null) {
                    filter.setAsyncSupported(asyncSupported.asBoolean());
                }
                if ((initParamsValue = annotation.value("initParams")) != null && (initParamsAnnotations = initParamsValue.asNestedArray()) != null && initParamsAnnotations.length > 0) {
                    initParams = new ArrayList();
                    for (AnnotationInstance initParamsAnnotation : initParamsAnnotations) {
                        Descriptions descriptions;
                        initParam = new ParamValueMetaData();
                        initParamName = initParamsAnnotation.value("name");
                        initParamValue = initParamsAnnotation.value();
                        if (initParamName == null || initParamValue == null) {
                            throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidWebInitParamAnnotation(target));
                        }
                        AnnotationValue initParamDescription = initParamsAnnotation.value("description");
                        initParam.setParamName(initParamName.asString());
                        initParam.setParamValue(initParamValue.asString());
                        if (initParamDescription != null && (descriptions = this.getDescription(initParamDescription.asString())) != null) {
                            initParam.setDescriptions(descriptions);
                        }
                        initParams.add(initParam);
                    }
                    filter.setInitParam(initParams);
                }
                if ((descriptionGroup = this.getDescriptionGroup((descriptionValue = annotation.value("description")) == null ? "" : descriptionValue.asString(), (displayNameValue = annotation.value("displayName")) == null ? "" : displayNameValue.asString(), (smallIconValue = annotation.value("smallIcon")) == null ? "" : smallIconValue.asString(), (largeIconValue = annotation.value("largeIcon")) == null ? "" : largeIconValue.asString())) != null) {
                    filter.setDescriptionGroup(descriptionGroup);
                }
                filters.add((MappableMetaData)filter);
                FilterMappingMetaData filterMapping = new FilterMappingMetaData();
                filterMapping.setFilterName(filter.getName());
                urlPatterns = new ArrayList();
                ArrayList<String> servletNames = new ArrayList<String>();
                ArrayList<DispatcherType> dispatchers = new ArrayList<DispatcherType>();
                AnnotationValue urlPatternsValue = annotation.value("urlPatterns");
                if (urlPatternsValue != null) {
                    for (String urlPattern : urlPatternsValue.asStringArray()) {
                        urlPatterns.add(urlPattern);
                    }
                }
                if ((urlPatternsValue = annotation.value()) != null) {
                    for (String urlPattern : urlPatternsValue.asStringArray()) {
                        urlPatterns.add(urlPattern);
                    }
                }
                if (urlPatterns.size() > 0) {
                    filterMapping.setUrlPatterns(urlPatterns);
                }
                if ((servletNamesValue = annotation.value("servletNames")) != null) {
                    for (String servletName : servletNamesValue.asStringArray()) {
                        servletNames.add(servletName);
                    }
                }
                if (servletNames.size() > 0) {
                    filterMapping.setServletNames(servletNames);
                }
                if ((dispatcherTypesValue = annotation.value("dispatcherTypes")) != null) {
                    for (String dispatcherValue : dispatcherTypesValue.asEnumArray()) {
                        dispatchers.add(DispatcherType.valueOf((String)dispatcherValue));
                    }
                }
                if (dispatchers.size() > 0) {
                    filterMapping.setDispatchers(dispatchers);
                }
                if (urlPatterns.size() <= 0 && servletNames.size() <= 0) continue;
                filterMappings.add(filterMapping);
            }
            metaData.setFilters(filters);
            metaData.setFilterMappings(filterMappings);
        }
        if ((webListenerAnnotations = index.getAnnotations(webListener)) != null && webListenerAnnotations.size() > 0) {
            ArrayList<ListenerMetaData> listeners = new ArrayList<ListenerMetaData>();
            for (AnnotationInstance annotation : webListenerAnnotations) {
                DescriptionGroupMetaData descriptionGroup2;
                ListenerMetaData listener = new ListenerMetaData();
                target = annotation.target();
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidWebListenerAnnotation(target));
                }
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                listener.setListenerClass(classInfo.toString());
                AnnotationValue descriptionValue2 = annotation.value();
                if (descriptionValue2 != null && (descriptionGroup2 = this.getDescriptionGroup(descriptionValue2.asString())) != null) {
                    listener.setDescriptionGroup(descriptionGroup2);
                }
                listeners.add(listener);
            }
            metaData.setListeners(listeners);
        }
        if ((runAsAnnotations = index.getAnnotations(runAs)) != null && runAsAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : runAsAnnotations) {
                target = annotation.target();
                if (!(target instanceof ClassInfo)) continue;
                classInfo = (ClassInfo)ClassInfo.class.cast(target);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                if (annotation.value() == null) {
                    throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidRunAsAnnotation(target));
                }
                RunAsMetaData runAs = new RunAsMetaData();
                runAs.setRoleName(annotation.value().asString());
                annotationMD.setRunAs(runAs);
            }
        }
        if ((declareRolesAnnotations = index.getAnnotations(declareRoles)) != null && declareRolesAnnotations.size() > 0) {
            SecurityRolesMetaData securityRoles = metaData.getSecurityRoles();
            if (securityRoles == null) {
                securityRoles = new SecurityRolesMetaData();
                metaData.setSecurityRoles(securityRoles);
            }
            for (AnnotationInstance annotation : declareRolesAnnotations) {
                if (annotation.value() == null) {
                    throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidDeclareRolesAnnotation(annotation.target()));
                }
                for (String role : annotation.value().asStringArray()) {
                    SecurityRoleMetaData sr = new SecurityRoleMetaData();
                    sr.setRoleName(role);
                    securityRoles.add((MappableMetaData)sr);
                }
            }
        }
        if ((multipartConfigAnnotations = index.getAnnotations(multipartConfig)) != null && multipartConfigAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : multipartConfigAnnotations) {
                AnnotationValue fileSizeThresholdValue;
                AnnotationValue maxRequestSizeValue;
                AnnotationValue maxFileSizeValue;
                AnnotationTarget target3 = annotation.target();
                if (!(target3 instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidMultipartConfigAnnotation(target3));
                }
                ClassInfo classInfo3 = (ClassInfo)ClassInfo.class.cast(target3);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo3.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo3.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                MultipartConfigMetaData multipartConfig = new MultipartConfigMetaData();
                AnnotationValue locationValue = annotation.value("location");
                if (locationValue != null && locationValue.asString().length() > 0) {
                    multipartConfig.setLocation(locationValue.asString());
                }
                if ((maxFileSizeValue = annotation.value("maxFileSize")) != null && maxFileSizeValue.asLong() != -1L) {
                    multipartConfig.setMaxFileSize(maxFileSizeValue.asLong());
                }
                if ((maxRequestSizeValue = annotation.value("maxRequestSize")) != null && maxRequestSizeValue.asLong() != -1L) {
                    multipartConfig.setMaxRequestSize(maxRequestSizeValue.asLong());
                }
                if ((fileSizeThresholdValue = annotation.value("fileSizeThreshold")) != null && fileSizeThresholdValue.asInt() != 0) {
                    multipartConfig.setFileSizeThreshold(fileSizeThresholdValue.asInt());
                }
                annotationMD.setMultipartConfig(multipartConfig);
            }
        }
        if ((servletSecurityAnnotations = index.getAnnotations(servletSecurity)) != null && servletSecurityAnnotations.size() > 0) {
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationInstance annotation : servletSecurityAnnotations) {
                AnnotationInstance[] httpMethodConstraints;
                AnnotationTarget target4 = annotation.target();
                if (!(target4 instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.invalidServletSecurityAnnotation(target4));
                }
                ClassInfo classInfo4 = (ClassInfo)ClassInfo.class.cast(target4);
                AnnotationMetaData annotationMD = (AnnotationMetaData)annotations.get(classInfo4.toString());
                if (annotationMD == null) {
                    annotationMD = new AnnotationMetaData();
                    annotationMD.setClassName(classInfo4.toString());
                    annotations.add((MappableMetaData)annotationMD);
                }
                ServletSecurityMetaData servletSecurity = new ServletSecurityMetaData();
                AnnotationValue httpConstraintValue = annotation.value();
                ArrayList<String> rolesAllowed = new ArrayList<String>();
                if (httpConstraintValue != null) {
                    AnnotationValue rolesAllowedValue;
                    AnnotationValue httpConstraintTGValue;
                    AnnotationInstance httpConstraint = httpConstraintValue.asNested();
                    AnnotationValue httpConstraintERSValue = httpConstraint.value();
                    if (httpConstraintERSValue != null) {
                        servletSecurity.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf((String)httpConstraintERSValue.asEnum()));
                    }
                    if ((httpConstraintTGValue = httpConstraint.value("transportGuarantee")) != null) {
                        servletSecurity.setTransportGuarantee(TransportGuaranteeType.valueOf((String)httpConstraintTGValue.asEnum()));
                    }
                    if ((rolesAllowedValue = httpConstraint.value("rolesAllowed")) != null) {
                        for (String role : rolesAllowedValue.asStringArray()) {
                            rolesAllowed.add(role);
                        }
                    }
                }
                servletSecurity.setRolesAllowed(rolesAllowed);
                AnnotationValue httpMethodConstraintsValue = annotation.value("httpMethodConstraints");
                if (httpMethodConstraintsValue != null && (httpMethodConstraints = httpMethodConstraintsValue.asNestedArray()).length > 0) {
                    ArrayList<HttpMethodConstraintMetaData> methodConstraints = new ArrayList<HttpMethodConstraintMetaData>();
                    for (AnnotationInstance httpMethodConstraint : httpMethodConstraints) {
                        AnnotationValue httpMethodConstraintTGValue;
                        AnnotationValue httpMethodConstraintERSValue;
                        HttpMethodConstraintMetaData methodConstraint = new HttpMethodConstraintMetaData();
                        AnnotationValue httpMethodConstraintValue = httpMethodConstraint.value();
                        if (httpMethodConstraintValue != null) {
                            methodConstraint.setMethod(httpMethodConstraintValue.asString());
                        }
                        if ((httpMethodConstraintERSValue = httpMethodConstraint.value("emptyRoleSemantic")) != null) {
                            methodConstraint.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf((String)httpMethodConstraintERSValue.asEnum()));
                        }
                        if ((httpMethodConstraintTGValue = httpMethodConstraint.value("transportGuarantee")) != null) {
                            methodConstraint.setTransportGuarantee(TransportGuaranteeType.valueOf((String)httpMethodConstraintTGValue.asEnum()));
                        }
                        AnnotationValue rolesAllowedValue = httpMethodConstraint.value("rolesAllowed");
                        rolesAllowed = new ArrayList();
                        if (rolesAllowedValue != null) {
                            for (String role : rolesAllowedValue.asStringArray()) {
                                rolesAllowed.add(role);
                            }
                        }
                        methodConstraint.setRolesAllowed(rolesAllowed);
                        methodConstraints.add(methodConstraint);
                    }
                    servletSecurity.setHttpMethodConstraints(methodConstraints);
                }
                annotationMD.setServletSecurity(servletSecurity);
            }
        }
        return metaData;
    }

    protected Descriptions getDescription(String description) {
        DescriptionsImpl descriptions = null;
        if (description.length() > 0) {
            DescriptionImpl di = new DescriptionImpl();
            di.setDescription(description);
            descriptions = new DescriptionsImpl();
            descriptions.add((MappableMetaData)di);
        }
        return descriptions;
    }

    protected DisplayNames getDisplayName(String displayName) {
        DisplayNamesImpl displayNames = null;
        if (displayName.length() > 0) {
            DisplayNameImpl dn = new DisplayNameImpl();
            dn.setDisplayName(displayName);
            displayNames = new DisplayNamesImpl();
            displayNames.add((MappableMetaData)dn);
        }
        return displayNames;
    }

    protected Icons getIcons(String smallIcon, String largeIcon) {
        IconsImpl icons = null;
        if (smallIcon.length() > 0 || largeIcon.length() > 0) {
            IconImpl i = new IconImpl();
            i.setSmallIcon(smallIcon);
            i.setLargeIcon(largeIcon);
            icons = new IconsImpl();
            icons.add((MappableMetaData)i);
        }
        return icons;
    }

    protected DescriptionGroupMetaData getDescriptionGroup(String description) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0) {
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = this.getDescription(description);
            dg.setDescriptions(descriptions);
        }
        return dg;
    }

    protected DescriptionGroupMetaData getDescriptionGroup(String description, String displayName, String smallIcon, String largeIcon) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0 || displayName.length() > 0 || smallIcon.length() > 0 || largeIcon.length() > 0) {
            Icons icons;
            DisplayNames displayNames;
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = this.getDescription(description);
            if (descriptions != null) {
                dg.setDescriptions(descriptions);
            }
            if ((displayNames = this.getDisplayName(displayName)) != null) {
                dg.setDisplayNames(displayNames);
            }
            if ((icons = this.getIcons(smallIcon, largeIcon)) != null) {
                dg.setIcons(icons);
            }
        }
        return dg;
    }
}

