/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.util.TreeSet;
import javax.security.jacc.URLPatternSpec;
import javax.security.jacc.WebResourcePermission;
import javax.servlet.http.HttpServletRequest;

public final class WebUserDataPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    private transient URLPatternSpec urlSpec;
    private transient String httpMethodsString;
    private transient String transportType;
    private transient TreeSet<String> httpMethods;
    private transient TreeSet<String> httpExceptionList;
    private transient String httpExceptionString;

    public WebUserDataPermission(HttpServletRequest request) {
        this(WebResourcePermission.requestURI(request), WebUserDataPermission.requestActions(request));
    }

    public WebUserDataPermission(String name, String actions) {
        super(name == null ? "/" : name);
        if (name == null) {
            name = "/";
        }
        this.urlSpec = new URLPatternSpec(name);
        this.parseActions(actions);
    }

    public WebUserDataPermission(String urlPatternSpec, String[] httpMethods, String transportType) {
        super(urlPatternSpec);
        this.urlSpec = new URLPatternSpec(urlPatternSpec);
        Object[] methodInfo = WebResourcePermission.canonicalMethods(httpMethods);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
        if (transportType != null && transportType.equalsIgnoreCase("NONE")) {
            transportType = null;
        }
        this.transportType = transportType;
    }

    public boolean equals(Object p) {
        if (p == null || !(p instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission perm = (WebUserDataPermission)p;
        return this.implies(perm) && perm.implies(this);
    }

    public String getActions() {
        String actions = null;
        if (this.httpMethodsString != null) {
            actions = this.transportType != null ? this.httpMethodsString + ":" + this.transportType : this.httpMethodsString;
        } else if (this.transportType != null) {
            actions = ":" + this.transportType;
        }
        return actions;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.urlSpec.hashCode();
        if (this.httpMethods != null) {
            hashCode = 37 * hashCode + this.httpMethods.hashCode();
        }
        return hashCode;
    }

    public boolean implies(Permission p) {
        if (p == null || !(p instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission perm = (WebUserDataPermission)p;
        boolean implies = this.urlSpec.implies(perm.urlSpec);
        if (implies) {
            if (this.httpExceptionList != null) {
                implies = WebResourcePermission.matchExceptionList(this.httpExceptionList, perm.httpExceptionList);
            }
            if (this.httpMethods != null && perm.httpMethods != null) {
                implies = this.httpMethods.containsAll(perm.httpMethods);
            }
            if (implies && this.transportType != null) {
                implies = this.transportType.equals(perm.transportType);
            }
        }
        return implies;
    }

    private static String requestActions(HttpServletRequest request) {
        String actions = request.getMethod() + (request.isSecure() ? ":CONFIDENTIAL" : "");
        return actions;
    }

    private void parseActions(String actions) {
        int colon;
        if (actions != null && (colon = actions.indexOf(58)) >= 0) {
            this.transportType = actions.substring(colon + 1);
            if (this.transportType.equalsIgnoreCase("NONE")) {
                this.transportType = null;
            }
            actions = actions.substring(0, colon);
        }
        boolean exceptionListNeeded = actions != null && actions.startsWith("!");
        Object[] methodInfo = WebResourcePermission.canonicalMethods(actions);
        if (exceptionListNeeded) {
            this.httpExceptionList = (TreeSet)methodInfo[0];
            this.httpExceptionString = (String)methodInfo[1];
        } else {
            this.httpMethods = (TreeSet)methodInfo[0];
            this.httpMethodsString = (String)methodInfo[1];
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String actions = (String)fields.get("actions", null);
        this.parseActions(actions);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("actions", this.getActions());
        oos.writeFields();
    }
}

