/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ClusteredCacheAdd
extends CacheAdd {
    public static SimpleAttributeDefinition MODE = new SimpleAttributeDefinitionBuilder("mode", ModelType.STRING, false).setXmlName(Attribute.MODE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(Mode.class, true, false)).build();

    ClusteredCacheAdd(CacheMode mode) {
        super(mode);
    }

    void populateMode(ModelNode fromModel, ModelNode toModel) {
        toModel.get("mode").set(Mode.forCacheMode(CacheMode.valueOf((String)fromModel.get("mode").asString())).name());
    }

    @Override
    void populateCacheMode(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        toModel.get("mode").set(Mode.valueOf(fromModel.require("mode").asString()).apply(this.mode).name());
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        super.populate(fromModel, toModel);
        CommonAttributes.ASYNC_MARSHALLING.validateAndSet(fromModel, toModel);
        CommonAttributes.QUEUE_SIZE.validateAndSet(fromModel, toModel);
        CommonAttributes.QUEUE_FLUSH_INTERVAL.validateAndSet(fromModel, toModel);
        CommonAttributes.REMOTE_TIMEOUT.validateAndSet(fromModel, toModel);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, cache, builder, dependencies);
        long remoteTimeout = CommonAttributes.REMOTE_TIMEOUT.resolveModelAttribute(context, cache).asLong();
        int queueSize = CommonAttributes.QUEUE_SIZE.resolveModelAttribute(context, cache).asInt();
        long queueFlushInterval = CommonAttributes.QUEUE_FLUSH_INTERVAL.resolveModelAttribute(context, cache).asLong();
        boolean asyncMarshalling = CommonAttributes.ASYNC_MARSHALLING.resolveModelAttribute(context, cache).asBoolean();
        if (CacheMode.valueOf((String)cache.get("mode").asString()).isSynchronous()) {
            builder.clustering().sync().replTimeout(remoteTimeout);
        } else {
            builder.clustering().async().replQueueMaxElements(queueSize);
            builder.clustering().async().replQueueInterval(queueFlushInterval);
            if (asyncMarshalling) {
                builder.clustering().async().asyncMarshalling();
            } else {
                builder.clustering().async().syncMarshalling();
            }
        }
    }
}

