/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.UUIDGenerator;

public class InVMConnection
implements Connection {
    private static final Logger log = Logger.getLogger(InVMConnection.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final String id;
    private boolean closed;
    public static boolean flushEnabled = true;
    private final int serverID;
    private final Executor executor;
    private volatile boolean closing;
    private HornetQPrincipal defaultHornetQPrincipal;

    public InVMConnection(Acceptor acceptor, int serverID, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor) {
        this(acceptor, serverID, UUIDGenerator.getInstance().generateSimpleStringUUID().toString(), handler, listener, executor);
    }

    public InVMConnection(Acceptor acceptor, int serverID, String id, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor) {
        this(acceptor, serverID, id, handler, listener, executor, null);
    }

    public InVMConnection(Acceptor acceptor, int serverID, String id, BufferHandler handler, ConnectionLifeCycleListener listener, Executor executor, HornetQPrincipal defaultHornetQPrincipal) {
        this.serverID = serverID;
        this.handler = handler;
        this.listener = listener;
        this.id = id;
        this.executor = executor;
        this.defaultHornetQPrincipal = defaultHornetQPrincipal;
        listener.connectionCreated(acceptor, this, ProtocolType.CORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        InVMConnection inVMConnection = this;
        synchronized (inVMConnection) {
            if (!this.closed) {
                this.listener.connectionDestroyed(this.id);
                this.closed = true;
            }
        }
    }

    @Override
    public HornetQBuffer createBuffer(int size) {
        return HornetQBuffers.dynamicBuffer(size);
    }

    @Override
    public Object getID() {
        return this.id;
    }

    @Override
    public void checkFlushBatchBuffer() {
    }

    @Override
    public void write(HornetQBuffer buffer) {
        this.write(buffer, false, false);
    }

    @Override
    public void write(HornetQBuffer buffer, boolean flush, boolean batch) {
        block5: {
            final HornetQBuffer copied = buffer.copy(0, buffer.capacity());
            copied.setIndex(buffer.readerIndex(), buffer.writerIndex());
            try {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!InVMConnection.this.closed) {
                                copied.readInt();
                                if (isTrace) {
                                    log.trace(InVMConnection.this + "::Sending inVM packet");
                                }
                                InVMConnection.this.handler.bufferReceived(InVMConnection.this.id, copied);
                            }
                        }
                        catch (Exception e) {
                            String msg = "Failed to write to handler on connector " + this;
                            log.error(msg, e);
                            throw new IllegalStateException(msg, e);
                        }
                        finally {
                            if (isTrace) {
                                log.trace(InVMConnection.this + "::packet sent done");
                            }
                        }
                    }
                });
                if (!flush || !flushEnabled) break block5;
                final CountDownLatch latch = new CountDownLatch(1);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
                try {
                    if (!latch.await(10L, TimeUnit.SECONDS)) {
                        log.warn("Timed out flushing channel on InVMConnection");
                    }
                }
                catch (InterruptedException e) {
                    log.debug(e.getMessage(), e);
                }
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
        }
    }

    @Override
    public String getRemoteAddress() {
        return "invm:" + this.serverID;
    }

    public int getBatchingBufferSize() {
        return -1;
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
    }

    @Override
    public HornetQPrincipal getDefaultHornetQPrincipal() {
        return this.defaultHornetQPrincipal;
    }

    public void disableFlush() {
        flushEnabled = false;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public String toString() {
        return "InVMConnection [serverID=" + this.serverID + ", id=" + this.id + "]";
    }
}

