/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerMessage;

public class LocalQueueBinding
implements QueueBinding {
    private static final Logger log = Logger.getLogger(LocalQueueBinding.class);
    private final SimpleString address;
    private final Queue queue;
    private final Filter filter;
    private final SimpleString name;
    private final SimpleString clusterName;

    public LocalQueueBinding(SimpleString address, Queue queue, SimpleString nodeID) {
        this.address = address;
        this.queue = queue;
        this.filter = queue.getFilter();
        this.name = queue.getName();
        this.clusterName = this.name.concat(nodeID);
    }

    @Override
    public long getID() {
        return this.queue.getID();
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Bindable getBindable() {
        return this.queue;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public SimpleString getRoutingName() {
        return this.name;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.name;
    }

    @Override
    public SimpleString getClusterName() {
        return this.clusterName;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public int getDistance() {
        return 0;
    }

    @Override
    public boolean isHighAcceptPriority(ServerMessage message) {
        return this.queue.hasMatchingConsumer(message);
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        this.queue.route(message, context);
    }

    public boolean isQueueBinding() {
        return true;
    }

    @Override
    public int consumerCount() {
        return this.queue.getConsumerCount();
    }

    @Override
    public BindingType getType() {
        return BindingType.LOCAL_QUEUE;
    }

    @Override
    public void close() throws Exception {
        this.queue.close();
    }

    public String toString() {
        return "LocalQueueBinding [address=" + this.address + ", queue=" + this.queue + ", filter=" + this.filter + ", name=" + this.name + ", clusterName=" + this.clusterName + "]";
    }
}

