/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.core.logging.impl.JULLogDelegateFactory;
import org.hornetq.spi.core.logging.LogDelegate;
import org.hornetq.spi.core.logging.LogDelegateFactory;
import org.hornetq.utils.ClassloadingUtil;

public class Logger {
    public static final String LOGGER_DELEGATE_FACTORY_CLASS_NAME = "org.hornetq.logger-delegate-factory-class-name";
    private static volatile LogDelegateFactory delegateFactory;
    private static final ConcurrentMap<Class<?>, Logger> loggers;
    private final LogDelegate delegate;

    public static synchronized void setDelegateFactory(LogDelegateFactory delegateFactory) {
        Logger.clear();
        Logger.delegateFactory = delegateFactory;
    }

    private static void clear() {
        loggers.clear();
    }

    public static synchronized void reset() {
        Logger.clear();
        Logger.initialise();
    }

    public static synchronized void initialise() {
        String className = JULLogDelegateFactory.class.getName();
        try {
            className = System.getProperty(LOGGER_DELEGATE_FACTORY_CLASS_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogDelegateFactory delegateFactory = className != null ? (LogDelegateFactory)Logger.safeInitNewInstance(className) : new JULLogDelegateFactory();
        Logger.delegateFactory = delegateFactory;
        loggers.clear();
    }

    public static Logger getLogger(Class<?> clazz) {
        LogDelegate delegate;
        Logger oldLogger;
        Logger logger = (Logger)loggers.get(clazz);
        if (logger == null && (oldLogger = loggers.putIfAbsent(clazz, logger = new Logger(delegate = delegateFactory.createDelegate(clazz)))) != null) {
            logger = oldLogger;
        }
        return logger;
    }

    Logger(LogDelegate delegate) {
        this.delegate = delegate;
    }

    public LogDelegate getDelegate() {
        return this.delegate;
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public void fatal(Object message) {
        this.delegate.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.delegate.fatal(message, t);
    }

    public void error(Object message) {
        this.delegate.error(message);
    }

    public void error(Object message, Throwable t) {
        this.delegate.error(message, t);
    }

    public void warn(Object message) {
        this.delegate.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.delegate.warn(message, t);
    }

    public void info(Object message) {
        this.delegate.info(message);
    }

    public void info(Object message, Throwable t) {
        this.delegate.info(message, t);
    }

    public void debug(Object message) {
        this.delegate.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.delegate.debug(message, t);
    }

    public void trace(Object message) {
        this.delegate.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.delegate.trace(message, t);
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassloadingUtil.newInstanceFromClassLoader(className);
            }
        });
    }

    static {
        loggers = new ConcurrentHashMap();
        Logger.initialise();
    }
}

