/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators;

import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.bridge.PPSPolicySetFinderModule;
import org.jboss.security.xacml.bridge.RPSPolicySetFinderModule;
import org.jboss.security.xacml.bridge.WrapperPolicyFinderModule;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.locators.JBossPolicySetLocator;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossRBACPolicySetLocator
extends JBossPolicySetLocator {
    public static final String ROLE_NS = "urn:oasis:names:tc:xacml:2.0:subject:role";
    public static final String RPS = "RPS";
    public static final String PPS = "PPS";
    protected RPSPolicySetFinderModule rpsFinderModule = new RPSPolicySetFinderModule();
    protected PPSPolicySetFinderModule ppsFinderModule = new PPSPolicySetFinderModule();

    @Override
    public void setPolicies(Set<XACMLPolicy> policies) {
        this.policies = policies;
        this.pfml.add(this.rpsFinderModule);
        this.pfml.add(this.ppsFinderModule);
        for (XACMLPolicy xp : policies) {
            if (xp.getType() == 0) {
                this.handlePolicy(xp);
                continue;
            }
            if (xp.getType() != 1) continue;
            Policy p = (Policy)xp.get("underlying_policy");
            WrapperPolicyFinderModule wpfm = new WrapperPolicyFinderModule(p);
            this.pfml.add(wpfm);
        }
        this.map.put("policy_finder_module", this.pfml);
    }

    protected void handlePolicy(XACMLPolicy xacmlPolicy) {
        AbstractPolicy aPolicy;
        List<XACMLPolicy> policyList = xacmlPolicy.getEnclosingPolicies();
        for (XACMLPolicy xp : policyList) {
            this.handlePolicy(xp);
        }
        if (policyList.size() == 0 && (aPolicy = (AbstractPolicy)xacmlPolicy.get("underlying_policy")) instanceof PolicySet) {
            PolicySet policySet = (PolicySet)aPolicy;
            if (policySet.getId().toASCIIString().contains(RPS)) {
                this.rpsFinderModule.add(policySet);
            } else if (policySet.getId().toASCIIString().contains(PPS)) {
                this.ppsFinderModule.add(policySet);
            }
        }
    }
}

