/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.security.xacml.interfaces.AbstractLocator;
import org.jboss.security.xacml.jaxb.Option;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinderModule;
import org.jboss.security.xacml.util.JBossXACMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLocator
extends AttributeFinderModule
implements AbstractLocator {
    protected String identifier = null;
    protected boolean attributeDesignatorSupported = true;
    protected boolean attributeSelectorSupported = true;
    protected Set<Integer> designatorTypes = new HashSet<Integer>();
    protected Set<URI> ids = new HashSet<URI>();
    protected List<Option> options = new ArrayList<Option>();
    protected Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public void setOptions(List<Option> options) {
        this.options = options;
        try {
            this.processOptions();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public <T> void set(String key, T obj) {
        this.map.put(key, obj);
    }

    @Override
    public String getIdentifier() {
        if (this.identifier == null) {
            return super.getIdentifier();
        }
        return this.identifier;
    }

    @Override
    public Set getSupportedDesignatorTypes() {
        return this.designatorTypes;
    }

    @Override
    public Set getSupportedIds() {
        return this.ids;
    }

    @Override
    public boolean isDesignatorSupported() {
        return this.attributeDesignatorSupported;
    }

    @Override
    public boolean isSelectorSupported() {
        return this.attributeSelectorSupported;
    }

    private void processOptions() throws Exception {
        for (Option option : this.options) {
            String tag = option.getName();
            List<Object> values = option.getContent();
            String value = (String)values.get(0);
            this.usePassedOption(tag, value);
        }
    }

    protected void usePassedOption(String optionTag, String optionValue) {
        if ("identifier".equals(optionTag)) {
            this.identifier = optionValue;
        } else if ("attributeDesignatorSupport".equals(optionTag)) {
            this.attributeDesignatorSupported = Boolean.parseBoolean(optionValue);
        } else if ("attributeSelectorSupport".equals(optionTag)) {
            this.attributeSelectorSupported = Boolean.parseBoolean(optionValue);
        } else if ("attributeSupportedId".equals(optionTag)) {
            try {
                List<String> tokens = JBossXACMLUtil.getTokenList(optionValue);
                int lengthOfTokens = tokens.size();
                for (int i = 0; i < lengthOfTokens; ++i) {
                    this.ids.add(new URI(tokens.get(i)));
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to create URI:", e);
            }
        } else if ("attributeDesignatorInt".equals(optionTag)) {
            this.designatorTypes.add(Integer.parseInt(optionValue));
        }
    }

    protected String getOptionValue(String optionTag) {
        Option option;
        int index = this.options.indexOf(optionTag);
        if (index > -1 && (option = this.options.get(index)) != null) {
            return (String)option.getContent().get(0);
        }
        return null;
    }

    protected Object getAttributeValue(EvaluationResult evalResult, URI attributeType) {
        if (evalResult != null) {
            AttributeValue attr = evalResult.getAttributeValue();
            return attr.getValue();
        }
        return null;
    }
}

