/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.ws.extensions.security.element.X509Token;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.SecurityActions;
import org.jboss.ws.extensions.security.operation.TokenOperation;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.w3c.dom.Document;

public class ReceiveX509Certificate
implements TokenOperation {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ReceiveX509Certificate.class);
    private static Logger log = Logger.getLogger(ReceiveX509Certificate.class);
    private SecurityAdaptorFactory secAdapterfactory;
    private CertificatePrincipal certMapping;

    public ReceiveX509Certificate(String certificatePrincipal) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.secAdapterfactory = (SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class);
        if (certificatePrincipal != null && !certificatePrincipal.equals("")) {
            try {
                ClassLoader loader = SecurityActions.getContextClassLoader();
                Class<?> cpClass = loader.loadClass(certificatePrincipal);
                this.certMapping = (CertificatePrincipal)cpClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_LOAD_CERTIFICATEPRINCIPAL", (Object[])new Object[]{certificatePrincipal}), (Throwable)e);
            }
        }
        if (this.certMapping == null) {
            this.certMapping = new SubjectDNMapping();
        }
    }

    @Override
    public void process(Document message, Token token) throws WSSecurityException {
        if (token == null || !(token instanceof X509Token)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"TOKEN_IS_NOT_A_X509TOKEN", (Object[])new Object[]{token}));
        }
        X509Certificate cert = ((X509Token)token).getCert();
        Principal principal = this.certMapping.toPrinicipal(new X509Certificate[]{cert});
        SecurityAdaptor securityAdaptor = this.secAdapterfactory.newSecurityAdapter();
        securityAdaptor.setPrincipal(principal);
        securityAdaptor.setCredential((Object)cert);
    }
}

