/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import org.apache.xml.security.utils.XMLUtils;
import org.jboss.util.Base64;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509Token
extends BinarySecurityToken {
    private static final ResourceBundle bundle = BundleUtils.getBundle(X509Token.class);
    private X509Certificate cert;
    public static final String TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";

    public X509Token(X509Certificate cert, Document doc) {
        super(doc);
        this.cert = cert;
    }

    public X509Token(Element element) throws WSSecurityException {
        super(element.getOwnerDocument());
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id != null && id.length() > 0) {
            this.setId(id);
        }
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(element.getAttribute("EncodingType"))) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_ENCODING_TYPE_(ONLY_BASE64_IS_SUPPORTED)_FOR_TOKEN", (Object[])new Object[]{id}));
        }
        this.setCert(this.decodeCert(XMLUtils.getFullTextChildrenFromElement((Element)element)));
    }

    @Override
    public String getEncodingType() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    }

    @Override
    public String getValueType() {
        return TYPE;
    }

    @Override
    public String getEncodedValue(boolean noWhitespace) {
        try {
            return Base64.encodeBytes((byte[])this.cert.getEncoded(), (int)(noWhitespace ? 8 : 0));
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_ENCODE_X509_TOKEN", (Object[])new Object[0]), e);
        }
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public X509Certificate decodeCert(String data) throws WSSecurityException {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)data)));
        }
        catch (Exception e) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_DECODING_BINARYSECURITYTOKEN", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @Override
    public Object getUniqueContent() {
        return this.cert;
    }
}

