/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxrpc.handler.ClientHandlerChain;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;

public class HandlerRegistryImpl
implements HandlerRegistry {
    private static final ResourceBundle bundle = BundleUtils.getBundle(HandlerRegistryImpl.class);
    private static Logger log = Logger.getLogger(HandlerRegistryImpl.class);
    private Map<QName, HandlerChain> handlerChains = new HashMap<QName, HandlerChain>();
    private Map<QName, List<HandlerInfo>> handlerInfos = new HashMap<QName, List<HandlerInfo>>();
    private ServiceMetaData serviceMetaData;

    public HandlerRegistryImpl(ServiceMetaData serviceMetaData) {
        this.serviceMetaData = serviceMetaData;
    }

    public List getHandlerChain(QName portName) {
        List<HandlerInfo> list = this.handlerInfos.get(portName);
        if (list == null) {
            list = new ArrayList<HandlerInfo>();
        }
        return new ArrayList<HandlerInfo>(list);
    }

    public void setHandlerChain(QName portName, List chain) {
        this.registerClientHandlerChain(portName, chain, null);
    }

    HandlerChain getHandlerChainInstance(QName portName) {
        HandlerChain handlerChain = this.handlerChains.get(portName);
        return handlerChain;
    }

    void registerClientHandlerChain(QName portName, List<HandlerInfo> infos, Set<String> roles) {
        ClientHandlerChain chain = new ClientHandlerChain((List)infos, (Set)roles);
        this.handlerChains.put(portName, chain);
        this.handlerInfos.put(portName, infos);
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_ENDPOINT_META_DATA", (Object[])new Object[]{portName}));
        }
        epMetaData.clearHandlers();
        for (HandlerInfo info : infos) {
            HandlerMetaDataJAXRPC handler = new HandlerMetaDataJAXRPC(UnifiedHandlerMetaData.HandlerType.ENDPOINT);
            handler.setEndpointMetaData(epMetaData);
            handler.setHandlerClassName(info.getHandlerClass().getName());
            handler.setSoapRoles(roles);
            HashSet<QName> headers = new HashSet<QName>();
            QName[] infoHeaders = info.getHeaders();
            if (infoHeaders != null) {
                for (QName header : infoHeaders) {
                    headers.add(header);
                }
            }
            handler.setSoapHeaders(headers);
            ArrayList<UnifiedInitParamMetaData> initParams = new ArrayList<UnifiedInitParamMetaData>();
            for (Map.Entry entry : info.getHandlerConfig().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                initParams.add(new UnifiedInitParamMetaData(key, (String)value));
            }
            handler.setInitParams(initParams);
            epMetaData.addHandler(handler);
            log.debug((Object)("Add handler to: " + portName + handler));
        }
    }
}

