/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.impl.RemotingModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public interface ModelControllerClient
extends Closeable {
    public ModelNode execute(ModelNode var1) throws IOException;

    public ModelNode execute(Operation var1) throws IOException;

    public ModelNode execute(ModelNode var1, OperationMessageHandler var2) throws IOException;

    public ModelNode execute(Operation var1, OperationMessageHandler var2) throws IOException;

    public AsyncFuture<ModelNode> executeAsync(ModelNode var1, OperationMessageHandler var2);

    public AsyncFuture<ModelNode> executeAsync(Operation var1, OperationMessageHandler var2);

    public static class Factory {
        public static ModelControllerClient create(InetAddress address, int port) {
            return new RemotingModelControllerClient(address.getHostName(), port, null, null);
        }

        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler) {
            return new RemotingModelControllerClient(address.getHostName(), port, handler, null);
        }

        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return new RemotingModelControllerClient(address.getHostName(), port, handler, saslOptions);
        }

        public static ModelControllerClient create(String hostName, int port) throws UnknownHostException {
            return new RemotingModelControllerClient(hostName, port, null, null);
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return new RemotingModelControllerClient(hostName, port, handler, null);
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return new RemotingModelControllerClient(hostName, port, handler, saslOptions);
        }
    }
}

