/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.InputStream;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ArchiveDeployer {
    private static final Logger log = Logger.getLogger(ArchiveDeployer.class);
    private ServerDeploymentManager deploymentManager;

    public ArchiveDeployer(ServerDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public String deploy(Archive<?> archive) throws DeploymentException {
        try {
            InputStream input = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            builder = builder.add(archive.getName(), input).andDeploy();
            DeploymentPlan plan = builder.build();
            DeploymentAction deployAction = builder.getLastAction();
            return this.executeDeploymentPlan(plan, deployAction);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy to container", (Throwable)e);
        }
    }

    public void undeploy(String runtimeName) throws DeploymentException {
        try {
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            DeploymentPlan plan = builder.undeploy(runtimeName).remove(runtimeName).build();
            Future future = this.deploymentManager.execute(plan);
            future.get();
        }
        catch (Exception ex) {
            log.warn((Object)("Cannot undeploy: " + runtimeName + ":" + ex.getMessage()));
        }
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deployAction.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
        return deployAction.getDeploymentUnitUniqueName();
    }
}

