/*
 * Copyright 2022-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.instancio.generator.specs;

import java.math.BigInteger;

/**
 * Spec for generating {@link BigInteger} values.
 *
 * @since 2.6.0
 */
public interface BigIntegerSpec extends NumberSpec<BigInteger> {

    @Override
    BigIntegerSpec min(BigInteger min);

    @Override
    BigIntegerSpec max(BigInteger max);

    @Override
    BigIntegerSpec range(BigInteger min, BigInteger max);

    @Override
    BigIntegerSpec nullable();
}
