/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.config;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class NodeEndPoint {
    private final String hostName;
    private final String ipAddress;
    private final int port;

    public NodeEndPoint(String hostName, String ipAddress, int port) {
        this.hostName = hostName != null ? hostName.trim() : null;
        this.ipAddress = ipAddress != null ? ipAddress.trim() : null;
        this.port = port;
    }

    public NodeEndPoint(String hostName, int port) {
        this(hostName, null, port);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.getInetSocketAddress(false);
    }

    public InetSocketAddress getInetSocketAddress(boolean reresolve) {
        if (reresolve || this.ipAddress == null || this.ipAddress.trim().equals("")) {
            return new InetSocketAddress(this.hostName, this.port);
        }
        try {
            return new InetSocketAddress(InetAddress.getByName(this.ipAddress), this.port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid server with hostName:" + this.hostName + ", IpAddress:" + this.ipAddress);
        }
    }

    public static NodeEndPoint copy(NodeEndPoint other) {
        return new NodeEndPoint(other.getHostName(), other.getIpAddress(), other.getPort());
    }

    public String toString() {
        return "NodeEndPoint - HostName:" + this.hostName + " IpAddress:" + this.ipAddress + " Port:" + this.port;
    }
}

