/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.query.ClosableIteratorWithCount;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.BaseEmbeddedQuery;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.impl.MappingIterator;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.util.logging.LogFactory;

public class HybridQuery<T, S>
extends BaseEmbeddedQuery<T> {
    private static final Log LOG = (Log)LogFactory.getLog(HybridQuery.class, Log.class);
    protected final ObjectFilter objectFilter;
    protected final Query<S> baseQuery;
    private final boolean allSortFieldsAreStored;

    public HybridQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, IckleParsingResult.StatementType statementType, Map<String, Object> namedParameters, ObjectFilter objectFilter, long startOffset, int maxResults, Query<?> baseQuery, LocalQueryStatistics queryStatistics, boolean local, boolean allSortFieldsAreStored) {
        super(queryFactory, cache, queryString, statementType, namedParameters, objectFilter.getProjection(), startOffset, maxResults, queryStatistics, local);
        this.objectFilter = objectFilter;
        this.baseQuery = baseQuery;
        this.allSortFieldsAreStored = allSortFieldsAreStored;
    }

    @Override
    protected void recordQuery(long time) {
        this.queryStatistics.hybridQueryExecuted(this.queryString, time);
    }

    @Override
    protected Comparator<Comparable<?>[]> getComparator() {
        return this.objectFilter.getComparator();
    }

    @Override
    protected ClosableIteratorWithCount<ObjectFilter.FilterResult> getInternalIterator() {
        return new MappingIterator<Object, ObjectFilter.FilterResult>(this.getBaseIterator(), arg_0 -> ((ObjectFilter)this.objectFilter).filter(arg_0));
    }

    protected CloseableIterator<?> getBaseIterator() {
        return this.baseQuery.startOffset(0L).maxResults(this.hybridMaxResult()).local(this.local).iterator();
    }

    protected int hybridMaxResult() {
        return this.allSortFieldsAreStored ? this.getMaxResults() + (int)this.getStartOffset() : Integer.MAX_VALUE;
    }

    @Override
    public QueryResult<T> execute() {
        if (this.isSelectStatement()) {
            return super.execute();
        }
        return new QueryResultImpl(this.executeStatement(), Collections.emptyList());
    }

    public int executeStatement() {
        if (this.isSelectStatement()) {
            throw LOG.unsupportedStatement();
        }
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        try {
            int n;
            block12: {
                ClosableIteratorWithCount entryIterator = this.baseQuery.startOffset(0L).maxResults(-1).local(this.local).entryIterator(false);
                try {
                    MappingIterator<EntityEntry, ObjectFilter.FilterResult> it = new MappingIterator<EntityEntry, ObjectFilter.FilterResult>((CloseableIterator<EntityEntry>)entryIterator, e -> this.objectFilter.filter(e.key(), e.value(), null));
                    int count = 0;
                    while (it.hasNext()) {
                        ObjectFilter.FilterResult fr = (ObjectFilter.FilterResult)it.next();
                        Object removed = this.cache.remove(fr.getKey());
                        if (removed == null) continue;
                        ++count;
                    }
                    n = count;
                    if (entryIterator == null) break block12;
                }
                catch (Throwable throwable) {
                    if (entryIterator != null) {
                        try {
                            entryIterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                entryIterator.close();
            }
            return n;
        }
        finally {
            if (this.queryStatistics.isEnabled()) {
                this.recordQuery(System.nanoTime() - start);
            }
        }
    }

    @Override
    public String toString() {
        return "HybridQuery{queryString=" + this.queryString + ", statementType=" + String.valueOf(this.statementType) + ", namedParameters=" + String.valueOf(this.namedParameters) + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + ", baseQuery=" + String.valueOf(this.baseQuery) + "}";
    }
}

