/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;

public class CustomInterceptorsConfigurationBuilder
extends AbstractConfigurationChildBuilder<CustomInterceptorsConfiguration> {
    private List<InterceptorConfigurationBuilder> interceptorBuilders = new LinkedList<InterceptorConfigurationBuilder>();

    CustomInterceptorsConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public InterceptorConfigurationBuilder addInterceptor() {
        InterceptorConfigurationBuilder builder = new InterceptorConfigurationBuilder(this);
        this.interceptorBuilders.add(builder);
        return builder;
    }

    @Override
    void validate() {
    }

    @Override
    CustomInterceptorsConfiguration create() {
        if (this.interceptorBuilders.isEmpty()) {
            return new CustomInterceptorsConfiguration();
        }
        ArrayList<InterceptorConfiguration> interceptors = new ArrayList<InterceptorConfiguration>(this.interceptorBuilders.size());
        for (InterceptorConfigurationBuilder builder : this.interceptorBuilders) {
            interceptors.add(builder.create());
        }
        return new CustomInterceptorsConfiguration(interceptors);
    }

    public CustomInterceptorsConfigurationBuilder read(CustomInterceptorsConfiguration template) {
        this.interceptorBuilders = new LinkedList<InterceptorConfigurationBuilder>();
        for (InterceptorConfiguration c : template.interceptors()) {
            this.interceptorBuilders.add(new InterceptorConfigurationBuilder(this).read(c));
        }
        return this;
    }

    public String toString() {
        return "CustomInterceptorsConfigurationBuilder{interceptors=" + this.interceptorBuilders + '}';
    }
}

