/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.xsite.BaseSiteUnreachableTest;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.status.BringSiteOnlineResponse;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.offline.NonTxOfflineTest")
public class NonTxOfflineTest
extends BaseSiteUnreachableTest {
    private static final int FAILURES = 8;
    private final Object[] keys = new Object[8];
    protected int nrRpcPerPut = 1;

    public NonTxOfflineTest() {
        this.failures = 8;
        this.lonBackupFailurePolicy = BackupFailurePolicy.FAIL;
    }

    public void testPutWithFailures() {
        int i;
        this.populateKeys(this.cache("LON-1", 0));
        DefaultTakeOfflineManager tom = this.takeOfflineManager("LON-1", 0);
        OfflineStatus nycStatus = tom.getOfflineStatus("NYC-2");
        for (i = 0; i < 8 / this.nrRpcPerPut; ++i) {
            try {
                AssertJUnit.assertEquals((Object)BringSiteOnlineResponse.ALREADY_ONLINE, (Object)tom.bringSiteOnline("NYC-2"));
                this.cache("LON-1", 0).put(this.keys[i], (Object)("v" + i));
                AssertJUnit.fail((String)"This should have failed");
                continue;
            }
            catch (Exception e) {
                this.eventuallyEquals(i + 1, () -> ((OfflineStatus)nycStatus).getFailureCount());
            }
        }
        AssertJUnit.assertTrue((boolean)nycStatus.isOffline());
        for (i = 0; i < 8; ++i) {
            this.cache("LON-1", 0).put(this.keys[i], (Object)("v" + i));
        }
        for (i = 0; i < 8; ++i) {
            AssertJUnit.assertEquals((Object)("v" + i), (Object)this.cache("LON-1", 0).get(this.keys[i]));
        }
        AssertJUnit.assertEquals((Object)BringSiteOnlineResponse.NO_SUCH_SITE, (Object)tom.bringSiteOnline("NO_SITE"));
        AssertJUnit.assertEquals((Object)BringSiteOnlineResponse.BROUGHT_ONLINE, (Object)tom.bringSiteOnline("NYC-2"));
        for (i = 0; i < 8 / this.nrRpcPerPut; ++i) {
            try {
                this.cache("LON-1", 0).put(this.keys[i], (Object)("v" + i));
                AssertJUnit.fail((String)"This should have failed");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return NonTxOfflineTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    private void populateKeys(Cache primaryOwner) {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new MagicKey("k" + i, primaryOwner);
        }
    }
}

