/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.irac.IracTombstoneCleanupCommand;
import org.infinispan.commands.irac.IracTombstonePrimaryCheckCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.versioning.irac.DefaultIracTombstoneManager;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.AbstractDelegatingRpcManager;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.status.TakeOfflineManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.irac.IracTombstoneCleanupTest")
public class IracTombstoneCleanupTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "xsite-tombstone";
    private static final String SITE_NAME = "LON-1";

    @Override
    protected void createCacheManagers() throws Throwable {
        TransportFlags flags = new TransportFlags().withSiteIndex(0).withSiteName(SITE_NAME).withFD(true);
        this.createClusteredCaches(3, CACHE_NAME, IracTombstoneCleanupTest.cacheConfiguration(), flags);
        for (Cache cache : this.caches(CACHE_NAME)) {
            IracTombstoneCleanupTest.tombstoneManager(cache).stopCleanupTask();
            TestingUtil.extractComponent(cache, TakeOfflineManager.class).takeSiteOffline("NYC");
        }
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        for (Cache cache : this.caches(CACHE_NAME)) {
            IracTombstoneCleanupTest.recordingRpcManager(cache).stopRecording();
        }
        super.clearContent();
    }

    private static ConfigurationBuilder cacheConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.clustering().hash().numOwners(2).numSegments(16);
        builder.sites().addBackup().site("NYC").strategy(BackupConfiguration.BackupStrategy.ASYNC).stateTransfer().chunkSize(1);
        return builder;
    }

    public void testPrimaryOwnerRoundCleanupsBackup(Method method) {
        String key = TestingUtil.k(method);
        int segment = this.getSegment(key);
        Cache<String, String> pCache = this.findPrimaryOwner(segment);
        Cache<String, String> bCache = this.findBackupOwner(segment);
        IracMetadata metadata = IracTombstoneCleanupTest.dummyMetadata(1L);
        IracTombstoneCleanupTest.tombstoneManager(pCache).storeTombstone(segment, (Object)key, metadata);
        IracTombstoneCleanupTest.tombstoneManager(bCache).storeTombstone(segment, (Object)key, metadata);
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(pCache).size());
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(bCache).size());
        RecordingRpcManager pRpcManager = IracTombstoneCleanupTest.recordingRpcManager(pCache);
        pRpcManager.startRecording();
        IracTombstoneCleanupTest.tombstoneManager(pCache).runCleanupAndWait();
        this.eventuallyEquals(0, () -> IracTombstoneCleanupTest.tombstoneManager(pCache).size());
        this.eventuallyEquals(0, () -> IracTombstoneCleanupTest.tombstoneManager(bCache).size());
        IracTombstoneCleanupCommand cmd = pRpcManager.findSingleCommand(IracTombstoneCleanupCommand.class);
        AssertJUnit.assertNotNull((Object)cmd);
        AssertJUnit.assertEquals((int)1, (int)cmd.getTombstonesToRemove().size());
        IracTombstoneInfo tombstone = (IracTombstoneInfo)cmd.getTombstonesToRemove().iterator().next();
        AssertJUnit.assertEquals((int)segment, (int)tombstone.getSegment());
        AssertJUnit.assertEquals((Object)key, (Object)tombstone.getKey());
        AssertJUnit.assertEquals((Object)metadata, (Object)tombstone.getMetadata());
    }

    public void testBackupOwnerRoundCleanupDoNotCleanupPrimary(Method method) {
        String key = TestingUtil.k(method);
        int segment = this.getSegment(key);
        Cache<String, String> pCache = this.findPrimaryOwner(segment);
        Cache<String, String> bCache = this.findBackupOwner(segment);
        IracMetadata metadata = IracTombstoneCleanupTest.dummyMetadata(2L);
        IracTombstoneCleanupTest.tombstoneManager(pCache).storeTombstone(segment, (Object)key, metadata);
        IracTombstoneCleanupTest.tombstoneManager(bCache).storeTombstone(segment, (Object)key, metadata);
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(pCache).size());
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(bCache).size());
        RecordingRpcManager pRpcManager = IracTombstoneCleanupTest.recordingRpcManager(pCache);
        RecordingRpcManager bRpcManager = IracTombstoneCleanupTest.recordingRpcManager(bCache);
        pRpcManager.startRecording();
        bRpcManager.startRecording();
        IracTombstoneCleanupTest.tombstoneManager(bCache).runCleanupAndWait();
        IracTombstonePrimaryCheckCommand cmd = bRpcManager.findSingleCommand(IracTombstonePrimaryCheckCommand.class);
        AssertJUnit.assertNotNull((Object)cmd);
        AssertJUnit.assertEquals((int)1, (int)cmd.getTombstoneToCheck().size());
        IracTombstoneInfo tombstoneInfo = (IracTombstoneInfo)cmd.getTombstoneToCheck().iterator().next();
        AssertJUnit.assertEquals((int)segment, (int)tombstoneInfo.getSegment());
        AssertJUnit.assertEquals((Object)key, (Object)tombstoneInfo.getKey());
        AssertJUnit.assertEquals((Object)metadata, (Object)tombstoneInfo.getMetadata());
        AssertJUnit.assertFalse((boolean)pRpcManager.isCommandSent(IracTombstoneCleanupCommand.class));
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(pCache).size());
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(bCache).size());
        IracTombstoneCleanupTest.tombstoneManager(pCache).removeTombstone((Object)key);
        IracTombstoneCleanupTest.tombstoneManager(bCache).removeTombstone((Object)key);
    }

    public void testNonOwnerRoundCleanupLocally(Method method) {
        String key = TestingUtil.k(method);
        int segment = this.getSegment(key);
        Cache<String, String> pCache = this.findPrimaryOwner(segment);
        Cache<String, String> bCache = this.findBackupOwner(segment);
        Cache<String, String> nCache = this.findNonOwner(segment);
        IracMetadata metadata = IracTombstoneCleanupTest.dummyMetadata(3L);
        IracTombstoneCleanupTest.tombstoneManager(pCache).storeTombstone(segment, (Object)key, metadata);
        IracTombstoneCleanupTest.tombstoneManager(bCache).storeTombstone(segment, (Object)key, metadata);
        IracTombstoneCleanupTest.tombstoneManager(nCache).storeTombstone(segment, (Object)key, metadata);
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(pCache).size());
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(bCache).size());
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(nCache).size());
        RecordingRpcManager pRpcManager = IracTombstoneCleanupTest.recordingRpcManager(pCache);
        RecordingRpcManager bRpcManager = IracTombstoneCleanupTest.recordingRpcManager(bCache);
        RecordingRpcManager nRpcManager = IracTombstoneCleanupTest.recordingRpcManager(nCache);
        pRpcManager.startRecording();
        bRpcManager.startRecording();
        nRpcManager.startRecording();
        IracTombstoneCleanupTest.tombstoneManager(nCache).runCleanupAndWait();
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(pCache).size());
        AssertJUnit.assertEquals((int)1, (int)IracTombstoneCleanupTest.tombstoneManager(bCache).size());
        AssertJUnit.assertEquals((int)0, (int)IracTombstoneCleanupTest.tombstoneManager(nCache).size());
        AssertJUnit.assertFalse((boolean)nRpcManager.isCommandSent(IracTombstonePrimaryCheckCommand.class));
        AssertJUnit.assertFalse((boolean)nRpcManager.isCommandSent(IracTombstoneCleanupCommand.class));
        AssertJUnit.assertFalse((boolean)bRpcManager.isCommandSent(IracTombstonePrimaryCheckCommand.class));
        AssertJUnit.assertFalse((boolean)bRpcManager.isCommandSent(IracTombstoneCleanupCommand.class));
        AssertJUnit.assertFalse((boolean)pRpcManager.isCommandSent(IracTombstonePrimaryCheckCommand.class));
        AssertJUnit.assertFalse((boolean)pRpcManager.isCommandSent(IracTombstoneCleanupCommand.class));
        IracTombstoneCleanupTest.tombstoneManager(pCache).removeTombstone((Object)key);
        IracTombstoneCleanupTest.tombstoneManager(bCache).removeTombstone((Object)key);
    }

    public void testStateTransfer(Method method) {
        int numberOfKeys = 100;
        ArrayList<IracTombstoneInfo> keys = new ArrayList<IracTombstoneInfo>(numberOfKeys);
        for (int i = 0; i < numberOfKeys; ++i) {
            String key = TestingUtil.k(method, i);
            int segment = this.getSegment(key);
            IracMetadata metadata = IracTombstoneCleanupTest.dummyMetadata(i * 2);
            keys.add(new IracTombstoneInfo((Object)key, segment, metadata));
        }
        Cache cache0 = this.cache(0, CACHE_NAME);
        Cache cache1 = this.cache(1, CACHE_NAME);
        for (IracTombstoneInfo tombstoneInfo2 : keys) {
            IracTombstoneCleanupTest.tombstoneManager(cache1).storeTombstone(tombstoneInfo2.getSegment(), tombstoneInfo2.getKey(), tombstoneInfo2.getMetadata());
        }
        AssertJUnit.assertEquals((int)0, (int)IracTombstoneCleanupTest.tombstoneManager(cache0).size());
        AssertJUnit.assertEquals((int)numberOfKeys, (int)IracTombstoneCleanupTest.tombstoneManager(cache1).size());
        int segment = ((IracTombstoneInfo)keys.get(0)).getSegment();
        IracTombstoneCleanupTest.tombstoneManager(cache1).sendStateTo(this.address(cache0), IntSets.immutableSet((int)segment));
        List segmentKeys = keys.stream().filter(tombstoneInfo -> segment == tombstoneInfo.getSegment()).collect(Collectors.toList());
        this.eventuallyEquals(segmentKeys.size(), () -> IracTombstoneCleanupTest.tombstoneManager(cache0).size());
        for (IracTombstoneInfo tombstone : segmentKeys) {
            AssertJUnit.assertTrue((boolean)IracTombstoneCleanupTest.tombstoneManager(cache0).contains(tombstone));
        }
        IracTombstoneCleanupTest.tombstoneManager(cache1).sendStateTo(this.address(cache0), IntSets.immutableRangeSet((int)16));
        this.eventuallyEquals(numberOfKeys, () -> IracTombstoneCleanupTest.tombstoneManager(cache0).size());
        for (IracTombstoneInfo tombstone : keys) {
            AssertJUnit.assertTrue((boolean)IracTombstoneCleanupTest.tombstoneManager(cache0).contains(tombstone));
        }
    }

    private Cache<String, String> findPrimaryOwner(int segment) {
        for (Cache cache : this.caches(CACHE_NAME)) {
            if (!TestingUtil.extractCacheTopology(cache).getSegmentDistribution(segment).isPrimary()) continue;
            return cache;
        }
        throw new IllegalStateException("Find primary owner failed!");
    }

    private Cache<String, String> findBackupOwner(int segment) {
        for (Cache cache : this.caches(CACHE_NAME)) {
            if (!TestingUtil.extractCacheTopology(cache).getSegmentDistribution(segment).isWriteBackup()) continue;
            return cache;
        }
        throw new IllegalStateException("Find backup owner failed!");
    }

    private Cache<String, String> findNonOwner(int segment) {
        for (Cache cache : this.caches(CACHE_NAME)) {
            if (TestingUtil.extractCacheTopology(cache).getSegmentDistribution(segment).isWriteOwner()) continue;
            return cache;
        }
        throw new IllegalStateException("Find non owner failed!");
    }

    private static IracMetadata dummyMetadata(long version) {
        TopologyIracVersion iracVersion = TopologyIracVersion.create((int)1, (long)version);
        return new IracMetadata(SITE_NAME, IracEntryVersion.newVersion((ByteString)ByteString.fromString((String)SITE_NAME), (TopologyIracVersion)iracVersion));
    }

    private int getSegment(String key) {
        return TestingUtil.extractCacheTopology(this.cache(0, CACHE_NAME)).getSegment((Object)key);
    }

    private static DefaultIracTombstoneManager tombstoneManager(Cache<?, ?> cache) {
        IracTombstoneManager tombstoneManager = TestingUtil.extractComponent(cache, IracTombstoneManager.class);
        assert (tombstoneManager instanceof DefaultIracTombstoneManager);
        return (DefaultIracTombstoneManager)tombstoneManager;
    }

    private static RecordingRpcManager recordingRpcManager(Cache<?, ?> cache) {
        RpcManager rpcManager = TestingUtil.extractComponent(cache, RpcManager.class);
        if (rpcManager instanceof RecordingRpcManager) {
            return (RecordingRpcManager)rpcManager;
        }
        return TestingUtil.wrapComponent(cache, RpcManager.class, RecordingRpcManager::new);
    }

    private static class RecordingRpcManager
    extends AbstractDelegatingRpcManager {
        @GuardedBy(value="this")
        private final List<CacheRpcCommand> commandList = new LinkedList<CacheRpcCommand>();
        private volatile boolean recording;

        RecordingRpcManager(RpcManager realOne) {
            super(realOne);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T extends CacheRpcCommand> T findSingleCommand(Class<T> commandClass) {
            CacheRpcCommand found = null;
            RecordingRpcManager recordingRpcManager = this;
            synchronized (recordingRpcManager) {
                for (CacheRpcCommand rpcCommand : this.commandList) {
                    if (rpcCommand.getClass() != commandClass) continue;
                    if (found != null) {
                        AssertJUnit.fail((String)("More than one " + String.valueOf(commandClass) + " found in list: " + String.valueOf(this.commandList)));
                    }
                    found = (CacheRpcCommand)commandClass.cast(rpcCommand);
                }
            }
            return (T)found;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T extends CacheRpcCommand> boolean isCommandSent(Class<T> commandClass) {
            boolean found = false;
            RecordingRpcManager recordingRpcManager = this;
            synchronized (recordingRpcManager) {
                for (CacheRpcCommand rpcCommand : this.commandList) {
                    if (rpcCommand.getClass() != commandClass) continue;
                    if (found) {
                        AssertJUnit.fail((String)("More than one " + String.valueOf(commandClass) + " found in list: " + String.valueOf(this.commandList)));
                    }
                    found = true;
                }
            }
            return found;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startRecording() {
            RecordingRpcManager recordingRpcManager = this;
            synchronized (recordingRpcManager) {
                this.commandList.clear();
            }
            this.recording = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopRecording() {
            this.recording = false;
            RecordingRpcManager recordingRpcManager = this;
            synchronized (recordingRpcManager) {
                this.commandList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected <T> CompletionStage<T> performRequest(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, Function<ResponseCollector<T>, CompletionStage<T>> invoker, RpcOptions rpcOptions) {
            if (this.recording && command instanceof CacheRpcCommand) {
                RecordingRpcManager recordingRpcManager = this;
                synchronized (recordingRpcManager) {
                    this.commandList.add((CacheRpcCommand)command);
                }
            }
            return super.performRequest(targets, command, collector, invoker, rpcOptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected <T> void performSend(Collection<Address> targets, ReplicableCommand command, Function<ResponseCollector<T>, CompletionStage<T>> invoker) {
            if (this.recording && command instanceof CacheRpcCommand) {
                RecordingRpcManager recordingRpcManager = this;
                synchronized (recordingRpcManager) {
                    this.commandList.add((CacheRpcCommand)command);
                }
            }
            super.performSend(targets, command, invoker);
        }
    }
}

