/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.xsite.irac.ControlledExponentialBackOff;
import org.infinispan.xsite.irac.ControlledTransport;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracManagerKeyChangedState;
import org.infinispan.xsite.irac.IracManagerKeyState;
import org.jgroups.UnreachableException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.iract.IracExponentialBackOffTest")
public class IracExponentialBackOffTest
extends SingleCacheManagerTest {
    private static final String LON = "LON";
    private static final String NYC = "NYC";
    private static final String CACHE_NAME = "irac-exponential-backoff";
    private static final Supplier<Throwable> NO_EXCEPTION = () -> null;
    private final ControlledExponentialBackOff backOff = new ControlledExponentialBackOff();
    private volatile ControlledTransport transport;
    private volatile DefaultIracManager iracManager;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        this.transport = TestingUtil.wrapGlobalComponent((CacheContainer)cacheManager, Transport.class, actual -> new ControlledTransport((Transport)actual, LON, (Collection<String>)Collections.singleton(NYC)), true);
        this.cache = ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache(CACHE_NAME, IracExponentialBackOffTest.createCacheConfiguration().build());
        this.iracManager = (DefaultIracManager)TestingUtil.extractComponent(this.cache, IracManager.class);
        this.iracManager.setBackOff(backup -> this.backOff);
        return cacheManager;
    }

    @AfterMethod(alwaysRun=true)
    public void resetStateAfterTest() {
        this.backOff.release();
        IracExponentialBackOffTest.eventually(() -> ((DefaultIracManager)this.iracManager).isEmpty());
        this.backOff.cleanupEvents();
        this.backOff.assertNoEvents();
    }

    @Override
    protected void teardown() {
        super.teardown();
        this.iracManager = null;
        this.transport = null;
    }

    private static ConfigurationBuilder createCacheConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.sites().addBackup().site(NYC).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        return builder;
    }

    public void testSimulatedTimeout(Method method) throws InterruptedException {
        this.doTest(method, () -> log.requestTimedOut(1L, NYC, "some time"));
    }

    public void testSimulatedUnreachableException(Method method) throws InterruptedException {
        this.doTest(method, () -> new UnreachableException(null));
    }

    public void testSimulatedSiteUnreachableEvent(Method method) throws InterruptedException {
        this.doTest(method, () -> log.remoteNodeSuspected(null));
    }

    public void testNoBackoffOnOtherException(Method method) throws InterruptedException {
        this.transport.throwableSupplier = CacheException::new;
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.cache.put((Object)key, (Object)value);
        this.backOff.eventually("Reset event with CacheException.", ControlledExponentialBackOff.Event.RESET);
        this.transport.throwableSupplier = NO_EXCEPTION;
        IracExponentialBackOffTest.eventually(() -> ((DefaultIracManager)this.iracManager).isEmpty());
        this.backOff.cleanupEvents();
        this.backOff.assertNoEvents();
    }

    private void doTest(Method method, Supplier<Throwable> throwableSupplier) throws InterruptedException {
        this.transport.throwableSupplier = throwableSupplier;
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        this.cache.put((Object)key, (Object)value);
        this.backOff.eventually("Backoff event on first try.", ControlledExponentialBackOff.Event.BACK_OFF);
        this.assertKeysEnterRetry(this.cache);
        this.backOff.release();
        this.backOff.eventually("Backoff event on second try.", ControlledExponentialBackOff.Event.BACK_OFF);
        this.transport.throwableSupplier = NO_EXCEPTION;
        this.backOff.release();
        IracExponentialBackOffTest.eventually(() -> ((DefaultIracManager)this.iracManager).isEmpty());
        this.backOff.eventually("Reset event after successful try", ControlledExponentialBackOff.Event.RESET);
        this.backOff.assertNoEvents();
    }

    private void assertKeysEnterRetry(Cache<?, ?> c) {
        DefaultIracManager dim = (DefaultIracManager)TestingUtil.extractComponent(c, IracManager.class);
        Map keys = (Map)TestingUtil.extractField(dim, "updatedKeys");
        ((MapAssert)Assertions.assertThat((Map)keys).withFailMessage("Wrong size: " + String.valueOf(keys), new Object[0])).hasSize(1);
        Predicate<IracManagerKeyState> predicate = state -> {
            IracManagerKeyChangedState.Status status = (IracManagerKeyChangedState.Status)TestingUtil.extractField(state, "status");
            return status == IracManagerKeyChangedState.Status.READY;
        };
        IracExponentialBackOffTest.eventually(() -> keys.values().stream().allMatch(predicate));
    }
}

