/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.backupfailure.tx;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.ExceptionRunnable;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.ClusteredCacheBackupReceiver;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.backupfailure.tx.BackupTxFailureTest")
public class BackupTxFailureTest
extends AbstractMultipleSitesTest {
    private static final String CACHE_A = "REPL_1PC_OTP";
    private static final String CACHE_B = "REPL_2PC_OTP";
    private static final String CACHE_C = "REPL_1PC_PES";
    private static final String CACHE_D = "REPL_2PC_PES";
    private static final String CACHE_E = "DIST_1PC_OTP";
    private static final String CACHE_F = "DIST_2PC_OTP";
    private static final String CACHE_G = "DIST_1PC_PES";
    private static final String CACHE_H = "DIST_2PC_PES";
    private static final List<String> ALL_CACHES = List.of("REPL_1PC_OTP", "REPL_2PC_OTP", "REPL_1PC_PES", "REPL_2PC_PES", "DIST_1PC_OTP", "DIST_2PC_OTP", "DIST_1PC_PES", "DIST_2PC_PES");
    private static final List<String> OPT_PC_CACHES = List.of("REPL_1PC_OTP", "REPL_2PC_OTP", "DIST_1PC_OTP", "DIST_2PC_OTP");

    /*
     * Exception decompiling
     */
    @DataProvider(name="all-caches")
    public static Object[][] allCaches() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @DataProvider(name="opt-caches")
    public static Object[][] optimisticCaches() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void afterSitesCreated() {
        super.afterSitesCreated();
        BackupTxFailureTest.defineInSite(this.site(0), CACHE_A, this.configFor(CacheMode.REPL_SYNC, LockingMode.OPTIMISTIC, false, this.siteName(1)));
        BackupTxFailureTest.defineInSite(this.site(1), CACHE_A, this.configFor(CacheMode.REPL_SYNC, LockingMode.OPTIMISTIC, false, this.siteName(0)));
        BackupTxFailureTest.defineInSite(this.site(0), CACHE_B, this.configFor(CacheMode.REPL_SYNC, LockingMode.OPTIMISTIC, true, this.siteName(1)));
        BackupTxFailureTest.defineInSite(this.site(1), CACHE_B, this.configFor(CacheMode.REPL_SYNC, LockingMode.OPTIMISTIC, true, this.siteName(0)));
        BackupTxFailureTest.defineInSite(this.site(0), CACHE_C, this.configFor(CacheMode.REPL_SYNC, LockingMode.PESSIMISTIC, false, this.siteName(1)));
        BackupTxFailureTest.defineInSite(this.site(1), CACHE_C, this.configFor(CacheMode.REPL_SYNC, LockingMode.PESSIMISTIC, false, this.siteName(0)));
        BackupTxFailureTest.defineInSite(this.site(0), CACHE_D, this.configFor(CacheMode.REPL_SYNC, LockingMode.PESSIMISTIC, true, this.siteName(1)));
        BackupTxFailureTest.defineInSite(this.site(1), CACHE_D, this.configFor(CacheMode.REPL_SYNC, LockingMode.PESSIMISTIC, true, this.siteName(0)));
        BackupTxFailureTest.defineInSite(this.site(0), CACHE_E, this.configFor(CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, false, this.siteName(1)));
        BackupTxFailureTest.defineInSite(this.site(1), CACHE_E, this.configFor(CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, false, this.siteName(0)));
        BackupTxFailureTest.defineInSite(this.site(0), CACHE_F, this.configFor(CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, true, this.siteName(1)));
        BackupTxFailureTest.defineInSite(this.site(1), CACHE_F, this.configFor(CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, true, this.siteName(0)));
        BackupTxFailureTest.defineInSite(this.site(0), CACHE_G, this.configFor(CacheMode.DIST_SYNC, LockingMode.PESSIMISTIC, false, this.siteName(1)));
        BackupTxFailureTest.defineInSite(this.site(1), CACHE_G, this.configFor(CacheMode.DIST_SYNC, LockingMode.PESSIMISTIC, false, this.siteName(0)));
        BackupTxFailureTest.defineInSite(this.site(0), CACHE_H, this.configFor(CacheMode.DIST_SYNC, LockingMode.PESSIMISTIC, true, this.siteName(1)));
        BackupTxFailureTest.defineInSite(this.site(1), CACHE_H, this.configFor(CacheMode.DIST_SYNC, LockingMode.PESSIMISTIC, true, this.siteName(0)));
        for (String name : ALL_CACHES) {
            this.site(0).waitForClusterToForm(name);
            this.site(1).waitForClusterToForm(name);
        }
    }

    private Configuration configFor(CacheMode cacheMode, LockingMode lockingMode, boolean useTwoPhaseCommit, String backup) {
        ConfigurationBuilder builder = BackupTxFailureTest.getDefaultClusteredCacheConfig(cacheMode, true);
        builder.transaction().lockingMode(lockingMode);
        builder.clustering().hash().numSegments(20);
        BackupConfigurationBuilder sitesBuilder = builder.sites().addBackup();
        sitesBuilder.site(backup).strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.FAIL).useTwoPhaseCommit(useTwoPhaseCommit);
        this.decorate(sitesBuilder);
        return builder.build();
    }

    protected void decorate(BackupConfigurationBuilder builder) {
    }

    protected void assertAfterTest(Cache<String, String> cache) {
    }

    @Test(dataProvider="all-caches")
    public void testFailDuringBackupReplay(String cacheName) {
        Cache localCache = this.cache(0, 0, cacheName);
        Cache remoteCache = this.cache(1, 0, cacheName);
        AbstractXSiteTest.AssertCondition condition = cache -> AssertJUnit.assertEquals((String)"initial", (String)((String)cache.get((Object)"key")));
        localCache.put((Object)"key", (Object)"initial");
        this.assertInAllSitesAndCaches(cacheName, condition);
        try (FailureInterceptor failureInterceptor = this.failureInterceptor(remoteCache);){
            failureInterceptor.enable(FailureEvent.WRITE);
            Exceptions.expectException(CacheException.class, RollbackException.class, () -> localCache.put((Object)"key", (Object)"wrong"));
        }
        this.assertInAllSitesAndCaches(cacheName, condition);
        this.assertNoTransaction(cacheName);
        this.assertAfterTest(localCache);
    }

    @Test(dataProvider="all-caches")
    public void testFailDuringBackupPrepare(String cacheName) {
        Cache localCache = this.cache(0, 0, cacheName);
        Cache remoteCache = this.cache(1, 0, cacheName);
        AbstractXSiteTest.AssertCondition condition = cache -> AssertJUnit.assertEquals((String)"initial", (String)((String)cache.get((Object)"key")));
        localCache.put((Object)"key", (Object)"initial");
        this.assertInAllSitesAndCaches(cacheName, condition);
        try (FailureInterceptor failureInterceptor = this.failureInterceptor(remoteCache);){
            failureInterceptor.enable(FailureEvent.PREPARE);
            Exceptions.expectException(CacheException.class, RollbackException.class, () -> localCache.put((Object)"key", (Object)"wrong"));
        }
        this.assertInAllSitesAndCaches(cacheName, condition);
        this.assertNoTransaction(cacheName);
        this.assertAfterTest(localCache);
    }

    @Test(dataProvider="opt-caches")
    public void testFailDuringLocalPrepare(String cacheName) {
        Cache localCache = this.cache(0, 0, cacheName);
        Cache otherLocalCAche = this.cache(0, 1, cacheName);
        AbstractXSiteTest.AssertCondition condition = cache -> AssertJUnit.assertEquals((String)"initial", (String)((String)cache.get((Object)"key")));
        localCache.put((Object)"key", (Object)"initial");
        this.assertInAllSitesAndCaches(cacheName, condition);
        try (FailureInterceptor failureInterceptor = this.failureInterceptor(otherLocalCAche);){
            failureInterceptor.enable(FailureEvent.PREPARE);
            Exceptions.expectException(CacheException.class, RollbackException.class, () -> localCache.put((Object)"key", (Object)"wrong"));
        }
        this.assertInAllSitesAndCaches(cacheName, condition);
        this.assertNoTransaction(cacheName);
    }

    @Test(dataProvider="all-caches")
    public void testConcurrency(String cacheName) throws ExecutionException, InterruptedException, TimeoutException {
        Cache site0 = this.cache(0, 0, cacheName);
        Cache site1 = this.cache(1, 0, cacheName);
        site0.put((Object)"counter", (Object)0);
        CountDownLatch latch = new CountDownLatch(1);
        int maxUpdates = 10;
        CounterRunnable c1 = new CounterRunnable(latch, (AdvancedCache<String, Integer>)site0.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK), maxUpdates);
        CounterRunnable c2 = new CounterRunnable(latch, (AdvancedCache<String, Integer>)site1.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT}), maxUpdates);
        Future<Void> f1 = this.fork(c1);
        Future<Void> f2 = this.fork(c2);
        latch.countDown();
        f1.get(10L, TimeUnit.SECONDS);
        f2.get(10L, TimeUnit.SECONDS);
        IntSet updates = IntSets.concurrentSet((int)(maxUpdates * 2));
        updates.addAll(c1.addedValues);
        for (Integer i : c2.addedValues) {
            AssertJUnit.assertTrue((String)("concurrent update detected: " + String.valueOf(c1.addedValues) + " - " + String.valueOf(c2.addedValues)), (boolean)updates.add((Object)i));
        }
        this.assertNoTransaction(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FailureInterceptor failureInterceptor(Cache<String, String> cache) {
        AsyncInterceptorChain chain;
        AsyncInterceptorChain asyncInterceptorChain = chain = TestingUtil.extractInterceptorChain(cache);
        synchronized (asyncInterceptorChain) {
            FailureInterceptor interceptor = (FailureInterceptor)chain.findInterceptorWithClass(FailureInterceptor.class);
            if (interceptor != null) {
                return interceptor;
            }
            interceptor = new FailureInterceptor();
            chain.addInterceptor((AsyncInterceptor)interceptor, 1);
            return interceptor;
        }
    }

    private void assertNoTransaction(String cacheName) {
        this.eventuallyAssertInAllSitesAndCaches(cacheName, cache -> TestingUtil.getTransactionTable(cache).getLocalTransactions().isEmpty());
        this.eventuallyAssertInAllSitesAndCaches(cacheName, cache -> TestingUtil.getTransactionTable(cache).getRemoteTransactions().isEmpty());
        this.eventuallyAssertInAllSitesAndCaches(cacheName, cache -> BackupTxFailureTest.backupReceiver(cache).isTransactionTableEmpty());
    }

    private static ClusteredCacheBackupReceiver backupReceiver(Cache<?, ?> cache) {
        BackupReceiver receiver = TestingUtil.extractComponent(cache, BackupReceiver.class);
        AssertJUnit.assertTrue((boolean)(receiver instanceof ClusteredCacheBackupReceiver));
        return (ClusteredCacheBackupReceiver)receiver;
    }

    private static /* synthetic */ Object[][] lambda$optimisticCaches$1(int x$0) {
        return new Object[x$0][];
    }

    private static /* synthetic */ Object[][] lambda$allCaches$1(int x$0) {
        return new Object[x$0][];
    }

    public static class FailureInterceptor
    extends DDAsyncInterceptor
    implements AutoCloseable {
        private volatile FailureEvent event;

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.failIf(FailureEvent.WRITE);
            return super.visitPutKeyValueCommand(ctx, command);
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            this.failIf(FailureEvent.PREPARE);
            return super.visitPrepareCommand(ctx, command);
        }

        private void failIf(FailureEvent currentEvent) {
            if (this.event == currentEvent) {
                throw new CacheException("Induced Exception");
            }
        }

        void enable(FailureEvent event) {
            this.event = Objects.requireNonNull(event);
        }

        void disable() {
            this.event = null;
        }

        @Override
        public void close() {
            this.disable();
        }
    }

    private static enum FailureEvent {
        WRITE,
        PREPARE;

    }

    private static class CounterRunnable
    implements ExceptionRunnable {
        final CountDownLatch latch;
        final AdvancedCache<String, Integer> cache;
        final int maxUpdates;
        final IntSet addedValues;

        private CounterRunnable(CountDownLatch latch, AdvancedCache<String, Integer> cache, int maxUpdates) {
            this.latch = latch;
            this.cache = cache;
            this.maxUpdates = maxUpdates;
            this.addedValues = IntSets.concurrentSet((int)maxUpdates);
        }

        public void run() {
            TransactionManager tm = this.cache.getTransactionManager();
            for (int i = 0; i < this.maxUpdates; ++i) {
                boolean failed = false;
                int updatedValue = -1;
                try {
                    tm.begin();
                    Integer value = (Integer)this.cache.get((Object)"counter");
                    updatedValue = value + 1;
                    this.cache.put((Object)"counter", (Object)updatedValue);
                }
                catch (Exception e) {
                    failed = true;
                }
                if (failed) {
                    try {
                        tm.rollback();
                    }
                    catch (SystemException e) {}
                } else {
                    try {
                        tm.commit();
                    }
                    catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
                        failed = true;
                    }
                }
                if (failed) continue;
                AssertJUnit.assertTrue((updatedValue > 0 ? 1 : 0) != 0);
                this.addedValues.add(updatedValue);
            }
        }
    }
}

