/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.backupfailure.tx;

import jakarta.transaction.Transaction;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CustomFailurePolicy;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.xsite.BackupFailureException;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.BackupSenderImpl;
import org.infinispan.xsite.backupfailure.tx.BackupTxFailureTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.backupfailure.tx.BackupCustomFailurePolicyTxFailureTest")
public class BackupCustomFailurePolicyTxFailureTest
extends BackupTxFailureTest {
    @Override
    protected void decorate(BackupConfigurationBuilder builder) {
        super.decorate(builder);
        builder.backupFailurePolicy(BackupFailurePolicy.CUSTOM).failurePolicyClass("org.infinispan.xsite.backupfailure.tx.BackupCustomFailurePolicyTxFailureTest$CountingFailurePolicy");
    }

    @Override
    protected void assertAfterTest(Cache<String, String> cache) {
        super.assertAfterTest(cache);
        BackupSender sender = TestingUtil.extractComponent(cache, BackupSender.class);
        AssertJUnit.assertTrue((boolean)(sender instanceof BackupSenderImpl));
        CustomFailurePolicy policy = ((BackupSenderImpl)sender).getCustomFailurePolicy(this.siteName(1));
        AssertJUnit.assertNotNull((Object)policy);
        AssertJUnit.assertTrue((boolean)(policy instanceof CountingFailurePolicy));
        if (this.isTwoPhaseCommit(cache) || this.isPessimisticLocking(cache)) {
            AssertJUnit.assertEquals((int)1, (int)((CountingFailurePolicy)policy).prepareFailCount.getAndSet(0));
            AssertJUnit.assertEquals((int)0, (int)((CountingFailurePolicy)policy).commitFailCount.getAndSet(0));
        } else {
            AssertJUnit.assertEquals((int)0, (int)((CountingFailurePolicy)policy).prepareFailCount.getAndSet(0));
            AssertJUnit.assertEquals((int)1, (int)((CountingFailurePolicy)policy).commitFailCount.getAndSet(0));
        }
    }

    private boolean isTwoPhaseCommit(Cache<?, ?> cache) {
        return cache.getCacheConfiguration().sites().syncBackupsStream().filter(backupConfiguration -> backupConfiguration.site().equals(this.siteName(1))).findFirst().map(BackupConfiguration::isTwoPhaseCommit).orElse(Boolean.FALSE);
    }

    private boolean isPessimisticLocking(Cache<?, ?> cache) {
        return cache.getCacheConfiguration().transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    public static class CountingFailurePolicy<K, V>
    implements CustomFailurePolicy<K, V> {
        final AtomicInteger prepareFailCount = new AtomicInteger();
        final AtomicInteger commitFailCount = new AtomicInteger();

        public void init(Cache<K, V> cache) {
        }

        public void handlePutFailure(String site, K key, V value, boolean putIfAbsent) {
        }

        public void handleRemoveFailure(String site, K key, V oldValue) {
        }

        public void handleReplaceFailure(String site, K key, V oldValue, V newValue) {
        }

        public void handleClearFailure(String site) {
        }

        public void handlePutAllFailure(String site, Map<K, V> map) {
        }

        public void handlePrepareFailure(String site, Transaction transaction) {
            this.prepareFailCount.incrementAndGet();
            throw new BackupFailureException();
        }

        public void handleRollbackFailure(String site, Transaction transaction) {
        }

        public void handleCommitFailure(String site, Transaction transaction) {
            this.commitFailCount.incrementAndGet();
            throw new BackupFailureException();
        }
    }
}

