/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.backupfailure;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.annotations.BeforeMethod;

public abstract class BaseBackupFailureTest
extends AbstractTwoSitesTest {
    protected FailureInterceptor failureInterceptor;

    @Override
    protected void createSites() {
        super.createSites();
        this.failureInterceptor = new FailureInterceptor();
        TestingUtil.extractInterceptorChain(this.backup("LON-1")).addInterceptor((AsyncInterceptor)this.failureInterceptor, 1);
    }

    @BeforeMethod
    void resetFailureInterceptor() {
        this.failureInterceptor.reset();
    }

    protected boolean failOnBackupFailure(String site, int cacheIndex) {
        return ((BackupConfiguration)this.cache(site, cacheIndex).getCacheConfiguration().sites().allBackups().get(0)).backupFailurePolicy() == BackupFailurePolicy.FAIL;
    }

    public static class FailureInterceptor
    extends DDAsyncInterceptor {
        protected volatile boolean isFailing = false;
        protected volatile boolean rollbackFailed;
        protected volatile boolean commitFailed;
        protected volatile boolean prepareFailed;
        protected volatile boolean putFailed;
        protected volatile boolean removeFailed;
        protected volatile boolean clearFailed;
        protected volatile boolean writeOnlyManyEntriesFailed;

        public void reset() {
            this.rollbackFailed = false;
            this.commitFailed = false;
            this.prepareFailed = false;
            this.putFailed = false;
            this.removeFailed = false;
            this.clearFailed = false;
            this.writeOnlyManyEntriesFailed = false;
            this.isFailing = false;
        }

        private Object handle(InvocationContext ctx, VisitableCommand command, Runnable logFailure) throws Throwable {
            if (this.isFailing) {
                logFailure.run();
                throw new CacheException("Induced failure");
            }
            return this.invokeNext(ctx, command);
        }

        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            return this.handle((InvocationContext)ctx, (VisitableCommand)command, () -> {
                this.rollbackFailed = true;
            });
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            return this.handle((InvocationContext)ctx, (VisitableCommand)command, () -> {
                this.commitFailed = true;
            });
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return this.handle((InvocationContext)ctx, (VisitableCommand)command, () -> {
                this.prepareFailed = true;
            });
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command, () -> {
                this.putFailed = true;
            });
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command, () -> {
                this.removeFailed = true;
            });
        }

        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command, () -> {
                this.clearFailed = true;
            });
        }

        public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command, () -> {
                this.writeOnlyManyEntriesFailed = true;
            });
        }

        public void disable() {
            this.isFailing = false;
        }

        public void enable() {
            this.isFailing = true;
        }
    }
}

