/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.XSiteAdminOperations;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.AsyncBackupExpirationTest")
public class AsyncBackupExpirationTest
extends AbstractTwoSitesTest {
    private ConfigMode lonConfigMode;
    private ConfigMode nycConfigMode;

    private static ConfigurationBuilder getConfig(ConfigMode configMode) {
        if (configMode == ConfigMode.NON_TX) {
            return AsyncBackupExpirationTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        }
        ConfigurationBuilder builder = AsyncBackupExpirationTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        switch (configMode.ordinal()) {
            case 2: {
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
                builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
                break;
            }
            case 3: {
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
                builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
                break;
            }
            case 1: {
                builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
            }
        }
        builder.expiration().wakeUpInterval(-1L);
        return builder;
    }

    @Override
    protected GlobalConfigurationBuilder globalConfigurationBuilderForSite(String siteName) {
        return super.globalConfigurationBuilderForSite(siteName);
    }

    @Factory
    public Object[] factory() {
        LinkedList<AsyncBackupExpirationTest> tests = new LinkedList<AsyncBackupExpirationTest>();
        for (ConfigMode lon : ConfigMode.values()) {
            for (ConfigMode nyc : ConfigMode.values()) {
                tests.add(new AsyncBackupExpirationTest().setLonConfigMode(lon).setNycConfigMode(nyc));
            }
        }
        return tests.toArray();
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"LON", "NYC"};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.lonConfigMode, this.nycConfigMode};
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return AsyncBackupExpirationTest.getConfig(this.nycConfigMode);
    }

    @BeforeMethod
    public void ensureSitesOnline() {
        XSiteAdminOperations adminOperations = TestingUtil.extractComponent(this.cache("LON-1", 0), XSiteAdminOperations.class);
        if ("offline".equals(adminOperations.siteStatus("NYC-2"))) {
            adminOperations.bringSiteOnline("NYC-2");
        }
        if ("offline".equals((adminOperations = TestingUtil.extractComponent(this.cache("NYC-2", 0), XSiteAdminOperations.class)).siteStatus("LON-1"))) {
            adminOperations.bringSiteOnline("LON-1");
        }
    }

    public AsyncBackupExpirationTest() {
        this.lonBackupStrategy = BackupConfiguration.BackupStrategy.ASYNC;
        this.nycBackupStrategy = BackupConfiguration.BackupStrategy.ASYNC;
        this.implicitBackupCache = true;
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return AsyncBackupExpirationTest.getConfig(this.lonConfigMode);
    }

    private AsyncBackupExpirationTest setLonConfigMode(ConfigMode configMode) {
        this.lonConfigMode = configMode;
        return this;
    }

    private AsyncBackupExpirationTest setNycConfigMode(ConfigMode configMode) {
        this.nycConfigMode = configMode;
        return this;
    }

    @DataProvider(name="two boolean cross product")
    public Object[][] tx() {
        return new Object[][]{{false, false}, {false, true}, {true, false}, {true, true}};
    }

    private ControlledTimeService replaceTimeService() {
        ControlledTimeService timeService = new ControlledTimeService();
        for (Cache c : this.caches("LON-1")) {
            TestingUtil.replaceComponent((CacheContainer)c.getCacheManager(), TimeService.class, timeService, true);
        }
        for (Cache c : this.caches("NYC-2")) {
            TestingUtil.replaceComponent((CacheContainer)c.getCacheManager(), TimeService.class, timeService, true);
        }
        return timeService;
    }

    @Test(dataProvider="two boolean cross product")
    public void testExpiredAccess(boolean lifespan, boolean readOnPrimary) {
        MagicKey key;
        Cache cache = this.cache("LON-1", 0);
        ControlledTimeService timeService = this.replaceTimeService();
        MagicKey magicKey = key = readOnPrimary ? new MagicKey(cache) : new MagicKey(this.cache("LON-1", 1));
        if (lifespan) {
            cache.put((Object)key, (Object)"v", 1L, TimeUnit.SECONDS);
        } else {
            cache.put((Object)key, (Object)"v", -1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
        }
        this.assertEventuallyInSite("LON-1", c -> Objects.equals("v", c.get((Object)key)), 20L, TimeUnit.SECONDS);
        this.assertEventuallyInSite("NYC-2", c -> Objects.equals("v", c.get((Object)key)), 20L, TimeUnit.SECONDS);
        Stream.concat(this.caches(0).stream(), this.caches(1).stream()).forEach(c -> {
            InternalCacheEntry ice = TestingUtil.extractComponent(c, InternalDataContainer.class).peek((Object)key);
            if (lifespan) {
                AssertJUnit.assertEquals((long)timeService.wallClockTime(), (long)ice.getCreated());
            } else {
                AssertJUnit.assertEquals((long)timeService.wallClockTime(), (long)ice.getLastUsed());
            }
        });
        timeService.advance(TimeUnit.SECONDS.toMillis(2L));
        this.assertInSite("LON-1", c -> AssertJUnit.assertNull((Object)c.get((Object)key)));
        this.assertInSite("NYC-2", c -> AssertJUnit.assertNull((Object)c.get((Object)key)));
    }

    @Test(dataProvider="two boolean cross product")
    public void testMaxIdleWithRecentAccess(boolean readFromWrittenSite, boolean readOnAccessedSite) {
        Cache mainSiteCache = this.cache("LON-1", 0);
        Cache backupSiteCache = this.cache("NYC-2", 0);
        ControlledTimeService timeService = this.replaceTimeService();
        MagicKey key = new MagicKey(this.cache("LON-1", 1));
        String value = "v";
        long accessTime = 10L;
        mainSiteCache.put((Object)key, (Object)value, -1L, TimeUnit.SECONDS, accessTime, TimeUnit.MILLISECONDS);
        this.eventuallyEquals(value, () -> backupSiteCache.get(key));
        timeService.advance(accessTime - 1L);
        Cache readSite = readFromWrittenSite ? mainSiteCache : backupSiteCache;
        Cache expiredSite = readFromWrittenSite ? backupSiteCache : mainSiteCache;
        AssertJUnit.assertEquals((Object)value, (Object)readSite.get((Object)key));
        timeService.advance(accessTime - 1L);
        if (readOnAccessedSite) {
            AssertJUnit.assertEquals((Object)value, (Object)readSite.get((Object)key));
        } else {
            AssertJUnit.assertEquals((Object)value, (Object)expiredSite.get((Object)key));
        }
        timeService.advance(accessTime + 1L);
        AssertJUnit.assertNull((Object)readSite.get((Object)key));
        AssertJUnit.assertNull((Object)expiredSite.get((Object)key));
    }

    private void takeBothOffline() {
        XSiteAdminOperations adminOperations = TestingUtil.extractComponent(this.cache("LON-1", 0), XSiteAdminOperations.class);
        adminOperations.takeSiteOffline("NYC-2");
        adminOperations = TestingUtil.extractComponent(this.cache("NYC-2", 0), XSiteAdminOperations.class);
        adminOperations.takeSiteOffline("LON-1");
    }

    @Test(dataProvider="two boolean cross product")
    public void testAccessButSiteGoesDown(boolean readFromPrimary, boolean readFromPrimaryAfterTakeOffline) {
        Cache mainSiteCache = this.cache("LON-1", 0);
        Cache backupSiteCache = this.cache("NYC-2", 0);
        ControlledTimeService timeService = this.replaceTimeService();
        String key = "key";
        String value = "v";
        long accessTime = 10L;
        mainSiteCache.put((Object)key, (Object)value, -1L, TimeUnit.SECONDS, accessTime, TimeUnit.MILLISECONDS);
        this.eventuallyEquals(value, () -> backupSiteCache.get(key));
        timeService.advance(accessTime - 1L);
        AssertJUnit.assertEquals((Object)value, (Object)(readFromPrimary ? mainSiteCache.get((Object)key) : backupSiteCache.get((Object)key)));
        this.takeBothOffline();
        timeService.advance(accessTime - 1L);
        AssertJUnit.assertEquals((Object)value, (Object)(readFromPrimaryAfterTakeOffline ? mainSiteCache.get((Object)key) : backupSiteCache.get((Object)key)));
    }

    private static enum ConfigMode {
        NON_TX,
        PESSIMISTIC_TX,
        OPTIMISTIC_TX_RC,
        OPTIMISTIC_TX_RR;

    }
}

