/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.exception;

import jakarta.transaction.RollbackException;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledRpcManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.exception.ReplicationTxExceptionTest")
public class ReplicationTxExceptionTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = ReplicationTxExceptionTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        this.registerCacheManager(new CacheContainer[]{TestCacheManagerFactory.createClusteredCacheManager(config)});
        this.registerCacheManager(new CacheContainer[]{TestCacheManagerFactory.createClusteredCacheManager(config)});
        TestingUtil.blockUntilViewsReceived(10000L, this.cache(0), this.cache(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicationFailure() throws Exception {
        Cache cache = this.cache(0);
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(cache, new Class[0]);
        try {
            Future<Void> future = this.fork(() -> {
                controlledRpcManager.expectCommand(VersionedPrepareCommand.class).fail();
                controlledRpcManager.expectCommand(RollbackCommand.class).send().receiveAll();
            });
            TransactionManager tm = this.cache(0).getAdvancedCache().getTransactionManager();
            tm.begin();
            this.cache(0).put((Object)"k0", (Object)"v");
            Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
            future.get(30L, TimeUnit.SECONDS);
        }
        finally {
            controlledRpcManager.revertRpcManager();
        }
    }
}

