/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TransactionCleanupTest")
public class TransactionCleanupTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = this.getConfiguration();
        this.createCluster(dcc, 2);
        this.waitForClusterToForm();
    }

    protected ConfigurationBuilder getConfiguration() {
        return TransactionCleanupTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
    }

    public void transactionCleanupTest1() throws Throwable {
        this.runtTest(1, false);
    }

    public void transactionCleanupTest2() throws Throwable {
        this.runtTest(0, false);
    }

    public void transactionCleanupTest3() throws Throwable {
        this.runtTest(1, true);
    }

    public void transactionCleanupTest4() throws Throwable {
        this.runtTest(0, true);
    }

    private void runtTest(int initiatorIndex, boolean rollback) throws Throwable {
        this.tm(initiatorIndex).begin();
        this.cache(initiatorIndex).put((Object)"k", (Object)"v");
        if (rollback) {
            this.tm(initiatorIndex).rollback();
        } else {
            this.tm(initiatorIndex).commit();
        }
        this.assertNotLocked("k");
        TransactionCleanupTest.eventually(() -> TestingUtil.getTransactionTable(this.cache(0)).getRemoteTxCount() == 0 && TestingUtil.getTransactionTable(this.cache(0)).getLocalTxCount() == 0 && TestingUtil.getTransactionTable(this.cache(1)).getRemoteTxCount() == 0 && TestingUtil.getTransactionTable(this.cache(1)).getLocalTxCount() == 0);
    }
}

