/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.concurrent.InvocationMatcher;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="tx.OptimisticPartialCommitTest")
public class OptimisticPartialCommitTest
extends MultipleCacheManagersTest {
    private ControlledConsistentHashFactory controlledCHFactory;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.controlledCHFactory = new ControlledConsistentHashFactory.Default(new int[][]{{1, 2}, {2, 3}});
        ConfigurationBuilder configuration = OptimisticPartialCommitTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        configuration.clustering().cacheMode(CacheMode.DIST_SYNC);
        configuration.clustering().hash().numSegments(2).numOwners(2).consistentHashFactory((ConsistentHashFactory)this.controlledCHFactory);
        configuration.transaction().lockingMode(LockingMode.OPTIMISTIC).locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.createCluster(TestDataSCI.INSTANCE, configuration, 4);
        this.waitForClusterToForm();
    }

    public void testNonOwnerBecomesOwnerDuringCommit() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.cache(1), this.cache(2));
        MagicKey k2 = new MagicKey("k2", this.cache(2), this.cache(3));
        this.cache(0).put((Object)k1, (Object)"v1_0");
        this.cache(0).put((Object)k2, (Object)"v2_0");
        StateSequencer ss = new StateSequencer();
        ss.logicalThread("main", "after_commit_on_1", "before_kill_3", "after_state_applied_on_1", "before_commit_on_2", "after_commit_on_2");
        StateSequencerUtil.advanceOnInterceptor(ss, this.cache(1), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(VersionedCommitCommand.class).matchCount(0).build()).after("after_commit_on_1", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(ss, this.cache(2), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(VersionedCommitCommand.class).matchCount(0).build()).before("before_commit_on_2", new String[0]).after("after_commit_on_2", new String[0]);
        InvocationMatcher stateAppliedOn0Matcher = StateSequencerUtil.matchMethodCall("handleRebalancePhaseConfirm").withParam(1, this.address(1)).build();
        StateSequencerUtil.advanceOnGlobalComponentMethod(ss, this.manager(0), ClusterTopologyManager.class, stateAppliedOn0Matcher).after("after_state_applied_on_1", new String[0]);
        Future<Object> txFuture = this.fork(() -> {
            this.tm(0).begin();
            try {
                this.cache(0).put(k1, (Object)"v1_1");
                this.cache(0).put(k2, (Object)"v2_1");
            }
            finally {
                this.tm(0).commit();
            }
            return null;
        });
        ss.advance("before_kill_3");
        this.controlledCHFactory.setOwnerIndexes(new int[][]{{1, 2}, {2, 1}});
        this.manager(3).stop();
        this.cacheManagers.remove(3);
        txFuture.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"v1_1", (Object)this.cache(1).get((Object)k1));
        AssertJUnit.assertEquals((Object)"v2_1", (Object)this.cache(1).get((Object)k2));
        AssertJUnit.assertEquals((Object)"v1_1", (Object)this.cache(2).get((Object)k1));
        AssertJUnit.assertEquals((Object)"v2_1", (Object)this.cache(2).get((Object)k2));
    }

    public void testOriginatorBecomesOwnerDuringCommit() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.cache(1), this.cache(2));
        MagicKey k2 = new MagicKey("k2", this.cache(2), this.cache(3));
        this.cache(1).put((Object)k1, (Object)"v1_0");
        this.cache(1).put((Object)k2, (Object)"v2_0");
        StateSequencer ss = new StateSequencer();
        ss.logicalThread("main", "before_kill_3", "after_state_applied_on_1", "before_commit_on_2", "after_commit_on_2", "after_commit_on_1");
        TransactionTable transactionTable = this.transactionTable(1);
        StateSequencerUtil.advanceOnInterceptor(ss, this.cache(1), StateTransferInterceptor.class, command -> {
            if (!(command instanceof VersionedCommitCommand)) {
                return false;
            }
            GlobalTransaction gtx = ((VersionedCommitCommand)command).getGlobalTransaction();
            LocalTransaction tx = transactionTable.getLocalTransaction(gtx);
            return tx.getStateTransferFlag() == null;
        }).after("after_commit_on_1", new String[0]);
        StateSequencerUtil.advanceOnInterceptor(ss, this.cache(2), StateTransferInterceptor.class, StateSequencerUtil.matchCommand(VersionedCommitCommand.class).matchCount(0).build()).before("before_commit_on_2", new String[0]).after("after_commit_on_2", new String[0]);
        InvocationMatcher stateAppliedOn0Matcher = StateSequencerUtil.matchMethodCall("handleRebalancePhaseConfirm").withParam(1, this.address(1)).build();
        StateSequencerUtil.advanceOnGlobalComponentMethod(ss, this.manager(0), ClusterTopologyManager.class, stateAppliedOn0Matcher).after("after_state_applied_on_1", new String[0]);
        Future<Object> txFuture = this.fork(() -> {
            this.tm(0).begin();
            try {
                this.cache(1).put(k1, (Object)"v1_1");
                this.cache(1).put(k2, (Object)"v2_1");
            }
            finally {
                this.tm(0).commit();
            }
            return null;
        });
        ss.advance("before_kill_3");
        this.controlledCHFactory.setOwnerIndexes(new int[][]{{1, 2}, {2, 1}});
        this.manager(3).stop();
        this.cacheManagers.remove(3);
        txFuture.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"v1_1", (Object)this.cache(1).get((Object)k1));
        AssertJUnit.assertEquals((Object)"v2_1", (Object)this.cache(1).get((Object)k2));
        AssertJUnit.assertEquals((Object)"v1_1", (Object)this.cache(2).get((Object)k1));
        AssertJUnit.assertEquals((Object)"v2_1", (Object)this.cache(2).get((Object)k2));
    }
}

