/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.transport.DelayedViewJGroupsTransport;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.InfinispanNodeFailureTest")
public class InfinispanNodeFailureTest
extends MultipleCacheManagersTest {
    private static final Integer INITIAL_VALUE = 0;
    private static final Integer REPLACING_VALUE = 1;
    private static final String TEST_CACHE = "test_cache";
    private CompletableFuture<Void> viewLatch;

    public void killedNodeDoesNotBreakReplaceCommand() throws Exception {
        this.defineConfigurationOnAllManagers(TEST_CACHE, new ConfigurationBuilder().read(this.manager(0).getDefaultCacheConfiguration(), Combine.DEFAULT));
        this.waitForClusterToForm(TEST_CACHE);
        TestingUtil.waitForNoRebalance(this.caches(TEST_CACHE));
        MagicKey replaceKey = new MagicKey("X", this.cache(0, TEST_CACHE));
        final MagicKey putKey = new MagicKey("Z", this.cache(1, TEST_CACHE));
        this.cache(0, TEST_CACHE).put((Object)replaceKey, (Object)INITIAL_VALUE);
        final CountDownLatch beforeKill = new CountDownLatch(1);
        final CountDownLatch afterKill = new CountDownLatch(1);
        TestingUtil.extractInterceptorChain(this.advancedCache(1, TEST_CACHE)).addInterceptor((AsyncInterceptor)new BaseCustomAsyncInterceptor(this){
            final /* synthetic */ InfinispanNodeFailureTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
                return this.invokeNextAndFinally((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv, t) -> {
                    LockControlCommand cmd = rCommand;
                    if (putKey.equals(cmd.getSingleKey())) {
                        beforeKill.countDown();
                        afterKill.await(10L, TimeUnit.SECONDS);
                    }
                });
            }
        }, 1);
        Future<Boolean> firstResult = this.fork(() -> {
            try {
                this.tm(0, TEST_CACHE).begin();
                boolean result = this.cache(0, TEST_CACHE).replace(replaceKey, (Object)INITIAL_VALUE, (Object)REPLACING_VALUE);
                this.cache(0, TEST_CACHE).put(putKey, (Object)"some-value");
                this.viewLatch.complete(null);
                this.tm(0, TEST_CACHE).commit();
                return result;
            }
            catch (Throwable t) {
                return null;
            }
        });
        AssertJUnit.assertTrue((boolean)beforeKill.await(10L, TimeUnit.SECONDS));
        this.killMember(2, TEST_CACHE, false);
        afterKill.countDown();
        this.tm(1, TEST_CACHE).begin();
        boolean secondResult = this.cache(1, TEST_CACHE).replace((Object)replaceKey, (Object)INITIAL_VALUE, (Object)REPLACING_VALUE);
        this.tm(1, TEST_CACHE).commit();
        AssertJUnit.assertEquals((Object)Boolean.TRUE, (Object)firstResult.get());
        AssertJUnit.assertEquals((Object)REPLACING_VALUE, (Object)this.cache(0, TEST_CACHE).get((Object)replaceKey));
        AssertJUnit.assertEquals((Object)REPLACING_VALUE, (Object)this.cache(1, TEST_CACHE).get((Object)replaceKey));
        AssertJUnit.assertEquals((boolean)false, (boolean)secondResult);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configuration = InfinispanNodeFailureTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        configuration.locking().useLockStriping(false).isolationLevel(IsolationLevel.READ_COMMITTED).lockAcquisitionTimeout(20000L);
        configuration.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC).useSynchronization(false).recovery().disable();
        configuration.clustering().hash().numSegments(60).stateTransfer().fetchInMemoryState(false);
        this.viewLatch = new CompletableFuture();
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.transport().transport((Transport)new DelayedViewJGroupsTransport(this.viewLatch));
        global.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        this.addClusterEnabledCacheManager(global, configuration);
        this.createCluster(TestDataSCI.INSTANCE, configuration, 2);
    }
}

