/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.SoftAssertions;
import org.infinispan.Cache;
import org.infinispan.commands.topology.CacheJoinCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.Mocks;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.testng.annotations.Test;

@Test(testName="topology.TopologyUnorderedJoinTest", groups={"functional"})
public class TopologyUnorderedJoinTest
extends MultipleCacheManagersTest {
    private final int dataSize = 100;
    private final String cacheName = "testCache";

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(this.defaultGlobalConfig(), this.defaultCacheConfig(), 2);
        for (EmbeddedCacheManager manager : this.managers()) {
            this.defineConfiguration(manager);
        }
    }

    private GlobalConfigurationBuilder defaultGlobalConfig() {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.transport().distributedSyncTimeout(15L, TimeUnit.SECONDS);
        return gcb;
    }

    private ConfigurationBuilder defaultCacheConfig() {
        ConfigurationBuilder cb = TopologyUnorderedJoinTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        cb.clustering().stateTransfer().timeout(30L, TimeUnit.SECONDS);
        return cb;
    }

    private EmbeddedCacheManager addNewMember() {
        return this.addClusterEnabledCacheManager(this.defaultGlobalConfig(), this.defaultCacheConfig());
    }

    private void defineConfiguration(EmbeddedCacheManager ecm) {
        ecm.defineConfiguration("testCache", this.defaultCacheConfig().build());
    }

    public void testDelayJoinResponseAfterRebalanceStart() throws Exception {
        this.waitForClusterToForm("testCache");
        this.populateCache();
        AtomicBoolean onlyOnce = new AtomicBoolean(true);
        CheckPoint joinPoint = Mocks.blockInboundGlobalCommandExecution(this.findCoordinator(), rc -> {
            if (rc instanceof CacheJoinCommand) {
                CacheJoinCommand cjc = (CacheJoinCommand)rc;
                return cjc.getCacheName().equals("testCache") && onlyOnce.getAndSet(false);
            }
            return false;
        });
        EmbeddedCacheManager joiner = this.addNewMember();
        this.defineConfiguration(joiner);
        Future<Cache> future = this.fork(() -> joiner.getCache("testCache"));
        joinPoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
        joinPoint.trigger("before_release");
        joinPoint.awaitStrict("after_invocation", 10L, TimeUnit.SECONDS);
        EmbeddedCacheManager ecm = this.addNewMember();
        this.defineConfiguration(ecm);
        TestingUtil.blockUntilViewsReceived(15000, this.caches());
        joinPoint.trigger("after_release");
        this.waitForClusterToForm("testCache");
        future.get(10L, TimeUnit.SECONDS);
        this.assertCacheData();
    }

    private void populateCache() {
        Cache cache = this.cache(0, "testCache");
        IntStream.range(0, 100).parallel().forEach(i -> cache.put((Object)("key-" + i), (Object)("value-" + i)));
    }

    private void assertCacheData() {
        SoftAssertions sa = new SoftAssertions();
        for (int m = 0; m < this.managers().length; ++m) {
            Cache cache = this.cache(m, "testCache");
            int size = cache.size();
            ((IntegerAssert)sa.assertThat(size).withFailMessage(String.format("Cache %d has %d/%d entries", m, size, 100), new Object[0])).isEqualTo(100);
            for (int i = 0; i < 100; ++i) {
                sa.assertThat((String)cache.get((Object)("key-" + i))).isEqualTo("value-" + i);
            }
        }
        sa.assertAll();
    }

    private EmbeddedCacheManager findCoordinator() {
        return this.manager(this.findCoordinatorIndex());
    }

    private int findCoordinatorIndex() {
        for (int i = 0; i < this.managers().length; ++i) {
            if (!this.manager(i).isCoordinator()) continue;
            return i;
        }
        throw new IllegalStateException("Coordinator node not found");
    }
}

