/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.List;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.CommandMatcher;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;

public class InboundRpcSequencerAction {
    private final StateSequencer stateSequencer;
    private final Cache<?, ?> cache;
    private final CommandMatcher matcher;
    private SequencerPerCacheInboundInvocationHandler ourHandler;

    public InboundRpcSequencerAction(StateSequencer stateSequencer, Cache cache, CommandMatcher matcher) {
        this.stateSequencer = stateSequencer;
        this.cache = cache;
        this.matcher = matcher;
    }

    public InboundRpcSequencerAction before(String state1, String ... additionalStates) {
        this.replaceInboundInvocationHandler();
        this.ourHandler.beforeStates(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    private void replaceInboundInvocationHandler() {
        if (this.ourHandler == null) {
            this.ourHandler = TestingUtil.wrapInboundInvocationHandler(this.cache, handler -> new SequencerPerCacheInboundInvocationHandler((PerCacheInboundInvocationHandler)handler, this.stateSequencer, this.matcher));
        }
    }

    public InboundRpcSequencerAction after(String state1, String ... additionalStates) {
        this.replaceInboundInvocationHandler();
        this.ourHandler.afterStates(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    public static class SequencerPerCacheInboundInvocationHandler
    extends AbstractDelegatingHandler {
        private final StateSequencer stateSequencer;
        private final CommandMatcher matcher;
        private volatile List<String> statesBefore;
        private volatile List<String> statesAfter;

        public SequencerPerCacheInboundInvocationHandler(PerCacheInboundInvocationHandler delegate, StateSequencer stateSequencer, CommandMatcher matcher) {
            super(delegate);
            this.stateSequencer = stateSequencer;
            this.matcher = matcher;
        }

        public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            boolean accepted = this.matcher.accept((ReplicableCommand)command);
            this.advance(accepted, this.statesBefore, reply);
            try {
                this.delegate.handle(command, response -> {
                    if (this.advance(accepted, this.statesAfter, reply)) {
                        reply.reply(response);
                    }
                }, order);
            }
            catch (Throwable t) {
                this.advance(accepted, this.statesAfter, Reply.NO_OP);
            }
        }

        public void beforeStates(List<String> states) {
            this.statesBefore = StateSequencerUtil.listCopy(states);
        }

        public void afterStates(List<String> states) {
            this.statesAfter = StateSequencerUtil.listCopy(states);
        }

        private boolean advance(boolean accepted, List<String> states, Reply reply) {
            try {
                StateSequencerUtil.advanceMultiple(this.stateSequencer, accepted, states);
                return true;
            }
            catch (TimeoutException e) {
                reply.reply((Response)new ExceptionResponse((Exception)e));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                reply.reply((Response)new ExceptionResponse((Exception)e));
            }
            return false;
        }
    }
}

