/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;

public class CherryPickClassLoader
extends ClassLoader {
    private static final Logger log = Logger.getLogger(CherryPickClassLoader.class);
    private final String[] includedClasses;
    private final String[] excludedClasses;
    private final String[] notFoundClasses;
    private final Map<String, Class> classes = new HashMap<String, Class>();

    public CherryPickClassLoader(String[] includedClasses, String[] excludedClasses, ClassLoader parent) {
        this(includedClasses, excludedClasses, null, parent);
    }

    public CherryPickClassLoader(String[] includedClasses, String[] excludedClasses, String[] notFoundClasses, ClassLoader parent) {
        super(parent);
        this.includedClasses = includedClasses;
        this.excludedClasses = excludedClasses;
        this.notFoundClasses = notFoundClasses;
        log.debugf("Created %s", (Object)this);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        log.tracef("loadClass(%s,%b)", (Object)name, (Object)resolve);
        if (this.isIncluded(name) && !this.isExcluded(name)) {
            Class<?> c = this.findClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        if (this.isNotFound(name)) {
            throw new ClassNotFoundException(name + " is discarded");
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        log.tracef("findClass(%s)", (Object)name);
        Class<?> result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        if (this.isIncluded(name) && !this.isExcluded(name)) {
            result = this.createClass(name);
        } else {
            if (this.isNotFound(name)) {
                throw new ClassNotFoundException(name + " is discarded");
            }
            result = super.findClass(name);
        }
        this.classes.put(name, result);
        return result;
    }

    protected Class createClass(String name) throws ClassFormatError, ClassNotFoundException {
        log.infof("createClass(%s)", (Object)name);
        try {
            int read;
            InputStream is = this.getResourceAsStream(name.replace('.', '/').concat(".class"));
            byte[] bytes = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            while ((read = is.read(bytes)) > -1) {
                baos.write(bytes, 0, read);
            }
            bytes = baos.toByteArray();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (FileNotFoundException e) {
            throw new ClassNotFoundException("cannot find " + name, e);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("cannot read " + name, e);
        }
    }

    protected boolean isIncluded(String className) {
        if (this.includedClasses != null) {
            for (int i = 0; i < this.includedClasses.length; ++i) {
                if (!className.startsWith(this.includedClasses[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isExcluded(String className) {
        if (this.excludedClasses != null) {
            for (int i = 0; i < this.excludedClasses.length; ++i) {
                if (!className.startsWith(this.excludedClasses[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isNotFound(String className) {
        if (this.notFoundClasses != null) {
            for (int i = 0; i < this.notFoundClasses.length; ++i) {
                if (!className.startsWith(this.notFoundClasses[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Object s = this.getClass().getName();
        s = (String)s + "[includedClasses=";
        s = (String)s + CherryPickClassLoader.listClasses(this.includedClasses);
        s = (String)s + ";excludedClasses=";
        s = (String)s + CherryPickClassLoader.listClasses(this.excludedClasses);
        s = (String)s + ";notFoundClasses=";
        s = (String)s + CherryPickClassLoader.listClasses(this.notFoundClasses);
        s = (String)s + ";parent=";
        s = (String)s + String.valueOf(this.getParent());
        s = (String)s + "]";
        return s;
    }

    private static String listClasses(String[] classes) {
        if (classes == null) {
            return null;
        }
        Object s = "";
        for (int i = 0; i < classes.length; ++i) {
            if (i > 0) {
                s = (String)s + ",";
            }
            s = (String)s + classes[i];
        }
        return s;
    }
}

