/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.File;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.ReplStateTransferCacheLoaderTest")
@CleanupAfterMethod
public class ReplStateTransferCacheLoaderTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(ReplStateTransferCacheLoaderTest.class);
    private File tmpDir;
    private GlobalConfigurationBuilder globalBuilder;
    private ConfigurationBuilder builder;

    @Override
    protected void createCacheManagers() {
        this.tmpDir = new File(CommonsTestingUtil.tmpDirectory(this.getClass()));
        Util.recursiveFileRemove((File)this.tmpDir);
        this.globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.globalBuilder.globalState().persistentLocation(this.tmpDir.getPath());
        this.builder = ReplStateTransferCacheLoaderTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true, true);
        this.builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).memory().size(1000L).locking().lockAcquisitionTimeout(20000L).concurrencyLevel(5000).useLockStriping(false).isolationLevel(IsolationLevel.READ_COMMITTED).memory().storageType(StorageType.BINARY).clustering().remoteTimeout(20000L).stateTransfer().timeout(240000L).fetchInMemoryState(false).chunkSize(10000).persistence().addSingleFileStore().location(new File(this.tmpDir, "store0").getAbsolutePath());
        this.createCluster(this.globalBuilder, this.builder, 1);
        this.waitForClusterToForm();
    }

    @AfterClass
    protected void clearTempDir() {
        Util.recursiveFileRemove((File)this.tmpDir);
    }

    public void testStateTransfer() {
        int i;
        int numKeys = 300;
        for (i = 0; i < 300; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        log.info((Object)"Finished putting keys");
        for (i = 0; i < 300; ++i) {
            AssertJUnit.assertEquals((Object)i, (Object)this.cache(0).get((Object)i));
        }
        log.info((Object)"Adding a new node ..");
        this.builder.persistence().clearStores().addSingleFileStore().location(new File(this.tmpDir, "store0").getAbsolutePath()).fetchPersistentState(true);
        this.addClusterEnabledCacheManager(this.globalBuilder, this.builder);
        log.info((Object)"Added a new node");
        for (i = 0; i < 300; ++i) {
            AssertJUnit.assertEquals((Object)i, (Object)this.cache(1).get((Object)i));
        }
    }
}

