/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.util.Map;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.CacheAuthorizationTest;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseAuthorizationTest
extends SingleCacheManagerTest {
    static final Log log = LogFactory.getLog(CacheAuthorizationTest.class);
    static final Subject ADMIN;
    static final Map<AuthorizationPermission, Subject> SUBJECTS;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            globalRoles.role(perm.toString()).permission(perm);
        }
        ConfigurationBuilder config = this.createCacheConfiguration(global);
        return (EmbeddedCacheManager)Security.doAs((Subject)ADMIN, () -> TestCacheManagerFactory.createCacheManager(global, config));
    }

    protected ConfigurationBuilder createCacheConfiguration(GlobalConfigurationBuilder global) {
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        config.transaction().lockingMode(LockingMode.PESSIMISTIC).invocationBatching().enable();
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            authConfig.role(perm.toString());
        }
        return config;
    }

    @Override
    protected void setup() throws Exception {
        this.cacheManager = this.createCacheManager();
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, () -> BaseAuthorizationTest.super.teardown());
    }

    @Override
    protected void clearContent() {
        Security.doAs((Subject)ADMIN, () -> this.cacheManager.getCache().clear());
    }

    static {
        SUBJECTS = TestingUtil.makeAllSubjects();
        ADMIN = SUBJECTS.get(AuthorizationPermission.ALL);
    }
}

