/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.profiling.testinternals;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskRunner {
    ExecutorService exec;

    public TaskRunner(int numThreads) {
        this(numThreads, false);
    }

    public TaskRunner(int numThreads, final boolean warmup) {
        final AtomicInteger counter = new AtomicInteger(0);
        final ThreadGroup tg = new ThreadGroup(Thread.currentThread().getThreadGroup(), warmup ? "WarmupLoadGenerators" : "LoadGenerators");
        this.exec = Executors.newFixedThreadPool(numThreads, new ThreadFactory(){
            final /* synthetic */ TaskRunner this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(tg, r, (warmup ? "WarmupLoadGenerator-" : "LoadGenerator-") + counter.incrementAndGet());
            }
        });
    }

    public void execute(Runnable r) {
        this.exec.execute(r);
    }

    public void stop() throws InterruptedException {
        this.exec.shutdown();
        while (!this.exec.awaitTermination(30L, TimeUnit.SECONDS)) {
            Thread.sleep(30L);
        }
    }
}

