/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.persistence.BaseStoreFunctionalTest;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.sifs.SoftIndexFileStoreFunctionalTest")
public class SoftIndexFileStoreFunctionalTest
extends BaseStoreFunctionalTest {
    protected String tmpDirectory;
    protected int segmentCount;

    public SoftIndexFileStoreFunctionalTest(int segmentCount) {
        this.segmentCount = segmentCount;
    }

    @Factory
    public static Object[] factory() {
        return new Object[]{new SoftIndexFileStoreFunctionalTest(1), new SoftIndexFileStoreFunctionalTest(10), new SoftIndexFileStoreFunctionalTest(256), new SoftIndexFileStoreFunctionalTest(2048)};
    }

    @Override
    protected String parameters() {
        return "[" + this.segmentCount + "]";
    }

    @BeforeClass(alwaysRun=true)
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @Override
    protected ConfigurationBuilder getDefaultCacheConfiguration() {
        ConfigurationBuilder configurationBuilder = super.getDefaultCacheConfiguration();
        configurationBuilder.clustering().hash().numSegments(this.segmentCount);
        return configurationBuilder;
    }

    @Override
    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, String cacheName, boolean preload) {
        ((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)persistence.addSoftIndexFileStore().dataLocation(Paths.get(this.tmpDirectory, "data").toString()).indexLocation(Paths.get(this.tmpDirectory, "index").toString()).purgeOnStartup(false)).preload(preload)).expiration().wakeUpInterval(Long.MAX_VALUE);
        return persistence;
    }

    public void testWritingSameKeyShortTimes() {
        String cacheName = "testWritingSameKeyShortTimes";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration(this.cacheManager, cacheName, cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        for (int i = 0; i < 32768; ++i) {
            cache.put((Object)"k", (Object)"v");
        }
        cache.remove((Object)"k");
    }

    @DataProvider(name="keyArgs")
    public Object[][] keyConfiguration() {
        return (Object[][])Stream.of(10, 10000, 250000).flatMap(keyCount -> Stream.of(Boolean.TRUE, Boolean.FALSE).map(largeKey -> new Object[]{keyCount, largeKey})).toArray(x$0 -> new Object[x$0][]);
    }

    @Test(dataProvider="keyArgs")
    public void testWriteManyDifferentKeysAndIterate(int keyCount, boolean largeKey) {
        String cacheName = "testWriteManyDifferentKeysAndIterate";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration(this.cacheManager, cacheName, cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        for (int i = 0; i < keyCount; ++i) {
            int anotherValue = i * 13 + (i - 1) * 19;
            String key = "k" + i + (String)(largeKey ? "-" + anotherValue : "");
            cache.put((Object)key, (Object)("v" + i + "-" + anotherValue));
        }
        cache.getAdvancedCache().getDataContainer().clear();
        ArrayList list = new ArrayList(cache.entrySet());
        if (list.size() > keyCount) {
            HashSet duplicateKeys = new HashSet();
            List dupList = list.stream().map(Map.Entry::getKey).filter(k -> !duplicateKeys.add(k)).map(k -> Map.entry(k, TestingUtil.extractComponent(cache, KeyPartitioner.class).getSegment(k))).collect(Collectors.toList());
            AssertJUnit.fail((String)("List contained a duplicate element" + String.valueOf(dupList)));
        } else {
            AssertJUnit.assertEquals((int)keyCount, (int)list.size());
        }
    }
}

