/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.support.DelayStore;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.FlushingAsyncStoreTest", singleThreaded=true)
public class FlushingAsyncStoreTest
extends SingleCacheManagerTest {
    public static final String CACHE_NAME = "AsyncStoreInMemory";

    public FlushingAsyncStoreTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder config = this.getDefaultStandaloneCacheConfig(false);
        ((DelayStore.ConfigurationBuilder)config.persistence().addStore(DelayStore.ConfigurationBuilder.class)).storeName(this.getClass().getName()).async().enable().build();
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager(config);
        cacheManager.defineConfiguration(CACHE_NAME, config.build());
        return cacheManager;
    }

    public void writeOnStorage() throws ExecutionException, InterruptedException, TimeoutException {
        this.cache = this.cacheManager.getCache(CACHE_NAME);
        DelayStore store = (DelayStore)TestingUtil.getFirstStore(this.cache);
        store.delayBeforeModification(1);
        this.cache.put((Object)"key1", (Object)"value");
        Future<Void> stopFuture = this.fork(() -> this.cache.stop());
        AssertJUnit.assertFalse((boolean)stopFuture.isDone());
        AssertJUnit.assertEquals((int)0, (int)store.stats().get("write"));
        store.endDelay();
        stopFuture.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)1, (int)store.stats().get("write"));
        AssertJUnit.assertEquals((long)1L, (long)DummyInMemoryStore.getStoreDataSize(store.getStoreName()));
    }
}

