/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.ConcurrentLoadAndEvictTest")
public class ConcurrentLoadAndEvictTest
extends SingleCacheManagerTest {
    SlowDownInterceptor sdi;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.sdi = new SlowDownInterceptor();
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
        TestCacheManagerFactory.addInterceptor(global, "defaultcache"::equals, (AsyncInterceptor)this.sdi, TestCacheManagerFactory.InterceptorPosition.AFTER, InvocationContextInterceptor.class);
        ConfigurationBuilder config = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)config.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return TestCacheManagerFactory.createCacheManager(global, config);
    }

    public void testEvictBeforeRead() throws PersistenceException, ExecutionException, InterruptedException {
        this.cache = this.cacheManager.getCache();
        this.cache.put((Object)"a", (Object)"b");
        assert (this.cache.get((Object)"a").equals("b"));
        DummyInMemoryStore cl = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        MarshallableEntry se = cl.loadEntry("a");
        assert (se != null);
        assert (se.getValue().equals("b"));
        this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).clear();
        se = cl.loadEntry("a");
        assert (se != null);
        assert (se.getValue().equals("b"));
        this.sdi.enabled = true;
        log.info((Object)"test::doing the get");
        Future<String> future = this.fork(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return (String)ConcurrentLoadAndEvictTest.this.cache.get((Object)"a");
            }
        });
        log.info((Object)"test::before the evict");
        this.cache.evict((Object)"a");
        log.info((Object)"test::after the evict");
        assert (future.get().equals("b"));
        this.sdi.enabled = false;
        assert (!TestingUtil.extractComponent(this.cache, InternalDataContainer.class).containsKey((Object)"a"));
    }

    public static class SlowDownInterceptor
    extends DDAsyncInterceptor {
        private static final Log log = LogFactory.getLog(SlowDownInterceptor.class);
        volatile boolean enabled = false;
        transient CountDownLatch getLatch = new CountDownLatch(1);
        transient CountDownLatch evictLatch = new CountDownLatch(1);

        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            if (this.enabled) {
                log.trace((Object)"Wait for evict to give go ahead...");
                if (!this.evictLatch.await(60000L, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("Didn't see get after 60 seconds!");
                }
            }
            return this.invokeNextAndFinally(ctx, (VisitableCommand)command, (rCtx, rCommand, rv, throwable) -> {
                log.trace((Object)"After get, now let evict go through");
                if (this.enabled) {
                    this.getLatch.countDown();
                }
            });
        }

        public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
            if (this.enabled) {
                this.evictLatch.countDown();
                log.trace((Object)"Wait for get to finish...");
                if (!this.getLatch.await(60000L, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("Didn't see evict after 60 seconds!");
                }
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
    }
}

