/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAException;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.LockingMode;
import org.jgroups.protocols.DISCARD;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="partitionhandling.PartitionStressTest", timeOut=900000L)
public class PartitionStressTest
extends MultipleCacheManagersTest {
    public static final int NUM_NODES = 4;

    @Override
    public Object[] factory() {
        return new Object[]{new PartitionStressTest().cacheMode(CacheMode.DIST_SYNC).transactional(false), new PartitionStressTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC), new PartitionStressTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(this.cacheMode);
        builder.transaction().transactionMode(this.transactionMode()).lockingMode(this.lockingMode);
        builder.clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        for (int i = 0; i < 4; ++i) {
            this.addClusterEnabledCacheManager(builder, new TransportFlags().withFD(true).withMerge(true));
        }
        this.waitForClusterToForm();
    }

    public void testWriteDuringPartition() throws Exception {
        DISCARD[] discards = new DISCARD[4];
        for (int i = 0; i < 4; ++i) {
            discards[i] = TestingUtil.getDiscardForCache(this.manager(i));
        }
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(4);
        final ConcurrentHashMap insertedKeys = new ConcurrentHashMap();
        final AtomicBoolean stop = new AtomicBoolean(false);
        int i = 0;
        while (i < 4) {
            final int cacheIndex = i++;
            Future<Object> future = this.fork(new Callable<Object>(){
                final /* synthetic */ PartitionStressTest this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object call() throws Exception {
                    Cache cache = this.this$0.cache(cacheIndex);
                    int count = 0;
                    while (!stop.get()) {
                        String key = "key" + cacheIndex + "_" + count;
                        try {
                            cache.put((Object)key, (Object)count);
                            insertedKeys.put(key, count);
                        }
                        catch (AvailabilityException availabilityException) {
                        }
                        catch (CacheException e) {
                            if (!(e.getCause() instanceof XAException) || e.getCause().getCause() instanceof AvailabilityException) {
                                // empty if block
                            }
                        }
                        ++count;
                        Thread.sleep(0L);
                    }
                    return count;
                }
            });
            futures.add(future);
        }
        long startTime = TIME_SERVICE.time();
        for (int splitIndex = 0; splitIndex < 4; ++splitIndex) {
            int i2;
            Iterator partitionOne = new ArrayList(4);
            ArrayList<Address> arrayList = new ArrayList<Address>(4);
            ArrayList<EmbeddedCacheManager> partitionOneManagers = new ArrayList<EmbeddedCacheManager>();
            ArrayList<EmbeddedCacheManager> partitionTwoManagers = new ArrayList<EmbeddedCacheManager>();
            for (int i22 = 0; i22 < 4; ++i22) {
                if ((i22 + splitIndex) % 4 < 2) {
                    arrayList.add(this.address(i22));
                    partitionTwoManagers.add(this.manager(i22));
                    continue;
                }
                partitionOne.add((Address)this.address(i22));
                partitionOneManagers.add(this.manager(i22));
            }
            AssertJUnit.assertEquals((int)2, (int)arrayList.size());
            log.infof("Cache is available, splitting cluster at index %d. First partition is %s, second partition is %s", (Object)splitIndex, partitionOne, arrayList);
            for (i2 = 0; i2 < 4; ++i2) {
                if (partitionOne.contains(this.address(i2))) {
                    for (Address a : arrayList) {
                        discards[i2].addIgnoreMember(((JGroupsAddress)a).getJGroupsAddress());
                    }
                    continue;
                }
                Iterator iterator = partitionOne.iterator();
                while (iterator.hasNext()) {
                    Address a;
                    a = (Address)iterator.next();
                    discards[i2].addIgnoreMember(((JGroupsAddress)a).getJGroupsAddress());
                }
            }
            TestingUtil.blockForMemberToFail(30000L, partitionOneManagers.toArray(new CacheContainer[0]));
            TestingUtil.blockForMemberToFail(30000L, partitionTwoManagers.toArray(new CacheContainer[0]));
            log.infof("Nodes split, waiting for the caches to become degraded", new Object[0]);
            PartitionStressTest.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return TestingUtil.extractComponent(PartitionStressTest.this.cache(0), PartitionHandlingManager.class).getAvailabilityMode() == AvailabilityMode.DEGRADED_MODE;
                }
            });
            this.assertFuturesRunning(futures);
            log.infof("Cache is degraded, merging partitions %s and %s", partitionOne, arrayList);
            for (i2 = 0; i2 < 4; ++i2) {
                discards[i2].resetIgnoredMembers();
            }
            TestingUtil.blockUntilViewsReceived(60000L, true, this.cacheManagers.toArray(new CacheContainer[0]));
            log.infof("Partitions merged, waiting for the caches to become available", new Object[0]);
            PartitionStressTest.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return TestingUtil.extractComponent(PartitionStressTest.this.cache(0), PartitionHandlingManager.class).getAvailabilityMode() == AvailabilityMode.AVAILABLE;
                }
            });
            TestingUtil.waitForNoRebalance(this.caches());
            this.assertFuturesRunning(futures);
        }
        stop.set(true);
        for (Future future : futures) {
            future.get(10L, TimeUnit.SECONDS);
        }
        for (String string : insertedKeys.keySet()) {
            for (int i3 = 0; i3 < 4; ++i3) {
                AssertJUnit.assertEquals((String)("Failure for key " + string + " on " + String.valueOf(this.cache(i3))), insertedKeys.get(string), (Object)this.cache(i3).get((Object)string));
            }
        }
        long duration = TIME_SERVICE.timeDuration(startTime, TimeUnit.SECONDS);
        log.infof("Test finished in %d seconds", (Object)duration);
    }

    protected void assertFuturesRunning(List<Future<Object>> futures) {
        for (Future<Object> future : futures) {
            AssertJUnit.assertFalse((boolean)future.isDone());
        }
    }
}

