/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.UncleanShutdownAction;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.testng.AssertJUnit;

public class BaseStatefulPartitionHandlingTest
extends BasePartitionHandlingTest {
    protected static final int DATA_SIZE = 100;
    protected static final String CACHE_NAME = "testCache";
    protected boolean createDefault;

    @Override
    protected String customCacheName() {
        return CACHE_NAME;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()}));
        this.createStatefulCacheManagers(true);
    }

    protected void createStatefulCacheManagers(boolean clear) {
        for (int i = 0; i < this.numMembersInCluster; ++i) {
            this.createStatefulCacheManager(Character.toString((char)(65 + i)), clear);
        }
    }

    void createStatefulCacheManager(String id, boolean clear) {
        this.createStatefulCacheManager(id, clear, true);
    }

    final void createStatefulCacheManager(String id, boolean clear, boolean start) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id});
        if (clear) {
            Util.recursiveFileRemove((String)stateDirectory);
        }
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory).uncleanShutdownAction(UncleanShutdownAction.IGNORE);
        global.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        ConfigurationBuilder config = new ConfigurationBuilder();
        this.partitionHandlingBuilder(config);
        config.persistence().addSingleFileStore().location(stateDirectory).fetchPersistentState(true);
        ConfigurationBuilder defaultConfig = this.createDefault ? config : null;
        EmbeddedCacheManager manager = TestCacheManagerFactory.createClusteredCacheManager(start, global, defaultConfig, new TransportFlags());
        this.cacheManagers.add(manager);
        if (start) {
            manager.defineConfiguration(CACHE_NAME, config.build());
        }
    }

    protected Map<JGroupsAddress, PersistentUUID> createInitialCluster() {
        this.waitForClusterToForm(CACHE_NAME);
        LinkedHashMap<JGroupsAddress, PersistentUUID> addressMappings = new LinkedHashMap<JGroupsAddress, PersistentUUID>();
        for (int i = 0; i < this.numMembersInCluster; ++i) {
            LocalTopologyManager ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(i), LocalTopologyManager.class);
            PersistentUUID uuid = ltm.getPersistentUUID();
            AssertJUnit.assertNotNull((Object)uuid);
            addressMappings.put((JGroupsAddress)this.manager(i).getAddress(), uuid);
        }
        this.fillData();
        this.checkData();
        return addressMappings;
    }

    private void fillData() {
        for (int i = 0; i < 100; ++i) {
            this.cache(0, CACHE_NAME).put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
    }

    void checkData() {
        AssertJUnit.assertEquals((int)100, (int)this.cache(0, CACHE_NAME).size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertEquals((Object)this.cache(0, CACHE_NAME).get((Object)String.valueOf(i)), (Object)String.valueOf(i));
        }
    }

    protected void assertHealthyCluster(Map<JGroupsAddress, PersistentUUID> addressMappings, ConsistentHash oldConsistentHash) throws Throwable {
        this.waitForClusterToForm(CACHE_NAME);
        this.checkClusterRestartedCorrectly(addressMappings);
        this.checkData();
        ConsistentHash newConsistentHash = this.advancedCache(0, CACHE_NAME).getDistributionManager().getWriteConsistentHash();
        PersistentUUIDManager persistentUUIDManager = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), PersistentUUIDManager.class);
        this.assertEquivalent(addressMappings, oldConsistentHash, newConsistentHash, persistentUUIDManager);
    }

    void checkClusterRestartedCorrectly(Map<JGroupsAddress, PersistentUUID> addressMappings) throws Exception {
        LocalTopologyManager ltm;
        int i;
        Iterator<Map.Entry<JGroupsAddress, PersistentUUID>> addressIterator = addressMappings.entrySet().iterator();
        HashSet<PersistentUUID> uuids = new HashSet<PersistentUUID>();
        for (i = 0; i < this.cacheManagers.size(); ++i) {
            ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(i), LocalTopologyManager.class);
            AssertJUnit.assertTrue((boolean)uuids.add(ltm.getPersistentUUID()));
        }
        for (i = 0; i < this.cacheManagers.size(); ++i) {
            ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(i), LocalTopologyManager.class);
            Map.Entry<JGroupsAddress, PersistentUUID> entry = addressIterator.next();
            AssertJUnit.assertTrue((String)(String.valueOf(entry.getKey()) + " is mapping to the wrong UUID: Expected: " + String.valueOf(entry.getValue()) + " not found in: " + String.valueOf(uuids)), (boolean)uuids.contains(entry.getValue()));
            AssertJUnit.assertTrue((boolean)ltm.isCacheRebalancingEnabled(CACHE_NAME));
        }
    }

    void assertEquivalent(Map<JGroupsAddress, PersistentUUID> addressMappings, ConsistentHash oldConsistentHash, ConsistentHash newConsistentHash, PersistentUUIDManager persistentUUIDManager) {
        AssertJUnit.assertTrue((boolean)this.isEquivalent(addressMappings, oldConsistentHash, newConsistentHash, persistentUUIDManager));
    }

    private boolean isEquivalent(Map<JGroupsAddress, PersistentUUID> addressMapping, ConsistentHash oldConsistentHash, ConsistentHash newConsistentHash, PersistentUUIDManager persistentUUIDManager) {
        if (oldConsistentHash.getNumSegments() != newConsistentHash.getNumSegments()) {
            return false;
        }
        for (int i = 0; i < oldConsistentHash.getMembers().size(); ++i) {
            Set newSegmentsForOwner;
            JGroupsAddress newAddress;
            JGroupsAddress oldAddress = (JGroupsAddress)oldConsistentHash.getMembers().get(i);
            JGroupsAddress remappedOldAddress = (JGroupsAddress)persistentUUIDManager.getAddress(addressMapping.get(oldAddress));
            if (!remappedOldAddress.equals((Object)(newAddress = (JGroupsAddress)newConsistentHash.getMembers().get(i)))) {
                return false;
            }
            Set oldSegmentsForOwner = oldConsistentHash.getSegmentsForOwner((Address)oldAddress);
            if (oldSegmentsForOwner.equals(newSegmentsForOwner = newConsistentHash.getSegmentsForOwner((Address)newAddress))) continue;
            return false;
        }
        return true;
    }
}

