/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import jakarta.transaction.RollbackException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import org.infinispan.Cache;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.BaseTxPartitionAndMergeTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.AssertJUnit;

public abstract class BaseOptimisticTxPartitionAndMergeTest
extends BaseTxPartitionAndMergeTest {
    static final String OPTIMISTIC_TX_CACHE_NAME = "opt-cache";

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        ConfigurationBuilder builder = BaseOptimisticTxPartitionAndMergeTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        builder.clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        builder.transaction().lockingMode(LockingMode.OPTIMISTIC).transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.defineConfigurationOnAllManagers(OPTIMISTIC_TX_CACHE_NAME, builder);
    }

    protected abstract void checkLocksDuringPartition(BaseTxPartitionAndMergeTest.SplitMode var1, BaseTxPartitionAndMergeTest.KeyInfo var2, boolean var3);

    protected abstract boolean forceRollback();

    protected abstract Class<? extends TransactionBoundaryCommand> getCommandClass();

    protected void doTest(BaseTxPartitionAndMergeTest.SplitMode splitMode, boolean txFail, boolean discard) throws Exception {
        this.waitForClusterToForm(OPTIMISTIC_TX_CACHE_NAME);
        BaseTxPartitionAndMergeTest.KeyInfo keyInfo = this.createKeys(OPTIMISTIC_TX_CACHE_NAME);
        Cache originator = this.cache(0, OPTIMISTIC_TX_CACHE_NAME);
        BaseTxPartitionAndMergeTest.FilterCollection filterCollection = this.createFilters(OPTIMISTIC_TX_CACHE_NAME, discard, this.getCommandClass(), splitMode);
        Future<Integer> put = this.fork(() -> {
            EmbeddedTransactionManager transactionManager = (EmbeddedTransactionManager)originator.getAdvancedCache().getTransactionManager();
            transactionManager.begin();
            keyInfo.putFinalValue((Cache<Object, String>)originator);
            EmbeddedTransaction transaction = transactionManager.getTransaction();
            transaction.runPrepare();
            transaction.runCommit(this.forceRollback());
            return transaction.getStatus();
        });
        filterCollection.await(30L, TimeUnit.SECONDS);
        splitMode.split(this);
        filterCollection.unblock();
        try {
            Integer txStatus = put.get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((int)(txFail ? 4 : 3), (int)txStatus);
        }
        catch (ExecutionException e) {
            if (txFail) {
                Exceptions.assertException(ExecutionException.class, RollbackException.class, XAException.class, AvailabilityException.class, (Throwable)e);
            }
            throw e;
        }
        this.checkLocksDuringPartition(splitMode, keyInfo, discard);
        filterCollection.stopDiscard();
        this.mergeCluster(OPTIMISTIC_TX_CACHE_NAME);
        this.finalAsserts(OPTIMISTIC_TX_CACHE_NAME, keyInfo, txFail ? "init-value" : "final-value");
    }
}

