/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import org.infinispan.commons.configuration.Combine;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.StoreAsBinaryConfigTest")
public class StoreAsBinaryConfigTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager ecm;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers(this.ecm);
        this.ecm = null;
    }

    public void testBackwardCompatibility() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.memory().storageType(StorageType.BINARY);
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)this.ecm.getCache().getCacheConfiguration().memory().storageType());
    }

    public void testConfigCloning() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.memory().storageType(StorageType.BINARY);
        ConfigurationBuilder builder = new ConfigurationBuilder().read(c.build(), Combine.DEFAULT);
        Configuration clone = builder.build();
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)clone.memory().storageType());
    }

    public void testConfigOverriding() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.memory().storageType(StorageType.BINARY);
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        this.ecm.defineConfiguration("newCache", new ConfigurationBuilder().read(c.build(), Combine.DEFAULT).memory().storageType(StorageType.OBJECT).build());
        AssertJUnit.assertEquals((Object)StorageType.OBJECT, (Object)this.ecm.getCache("newCache").getCacheConfiguration().memory().storageType());
    }
}

